#ifndef PICONSOLE_H
#define PICONSOLE_H

#include "pisysdep.h"

#include PISTDWDG_H 
#include PICONT_H
#include PIBWDG_H

enum PIVAType {    
  PIVA_Def = 0,
  PIVA_Bold = 1,
  PIVA_Ital = 2,
  PIVA_Reverse = 4
};

class PIConsole : public PIBaseWdg {
public:
                     PIConsole(PIContainer* par, char* nom, PIMessage msg,
                               int nl, int nc, int sx=300, int sy=200, int px=0, int py=0);
                     ~PIConsole();

          void       AddChar(char c, unsigned char va= PIVA_Def, bool ref=true);
          void       AddStr(char* strg, unsigned char va= PIVA_Def, bool ref=true);
//          void       MoveCursor(int il, int jc);
//          void       DelChar(int il, int jc); 

          void       SelectFont(PIFontSize sz=PI_NormalSizeFont);
          void       AcceptCmd(bool acc=true);
          void       SetPrompt(char* prompt); 
  inline  int        WindNbLines() { return mWSzL; }
  inline  int        NbLines() { return mNL; }
          void       SetDispOffset(int ldeb=-1);
          void       AssocScrollBar(PIScrollBar* scb);
          
  inline  string     GetCmdString() { mCmdStr[mCLC] = '\0'; return((string)mCmdStr); }

  virtual void       Draw(PIGraphicGen* g);
  virtual void       Resize();
  virtual void       Keyboard(int key, PIKeyModifier kmod);

          void       DebugPrint(int cont=0);

protected:
          void       ScrollUp();
          void       ClearLine(int l);
          void       DisplayLines(PIGraphicGen* g, int l1, int l2);
          void       UpdCmdLine();
          void       ClrCmd();
          void       CmdAddChar(int key);
  virtual void       Process(PIMessage msg, PIMsgHandler* sender, void* data=NULL);

  int mNL, mNC;
  int mCurL, mCurC; 
  int mWSzL, mWSzC, mOffL;
  int mNCmdL;
  char* mText;
  unsigned char* mAtt;
  int* mLPo;
  char* mStrBuf;
  int mFHaut, mFLarg;
  PIFontSize mFTaille;
  char  mPrompt[32];
  char* mCmdStr;
  int mCCP, mCLC;

// S il y a un scroll-bar associe
  PIScrollBar* mScb;
  PIMessage msgScb;
};


class PIScConsole : public PIContainer {
public :
                     PIScConsole(PIContainer* par, char* nom, PIMessage msg,
                               int nl, int nc, int sx=300, int sy=200, int px=0, int py=0);
                     ~PIScConsole();

  inline  void       AddChar(char c, unsigned char va= PIVA_Def, bool ref=true)
                             { mCons->AddChar(c, va, ref); }
  inline  void       AddStr(char* strg, unsigned char va= PIVA_Def, bool ref=true)
                             { mCons->AddStr(strg, va, ref); }

  inline  void       SelectFont(PIFontSize sz=PI_NormalSizeFont) 
                             { mCons->SelectFont(sz); }

  inline  void       AcceptCmd(bool acc=true)
                             { mCons->AcceptCmd(acc); }
  inline  void       SetPrompt(char* prompt) 
                             { mCons->SetPrompt(prompt); }

  inline  void       Refresh() { mCons->Refresh(); }

  PIConsole* mCons;

protected:
  PIScrollBar* mScb;
};

#endif
