// Classe Look-Up-Table  pour convertir image en entree ds
// une table de couleur.
//       Classe LUT              R. Ansari  05/95
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#include "defs.h"
#include <stdlib.h>
#include <stdio.h>
#include <math.h>

#include "lut.h"


/* --Methode-- */

LUT::LUT(float min, float max, int ncol, int typ) 
{
int nlev;

bornes=NULL;  
nlev = ncol-2;
if (nlev < 0)  nlev = 0;
bornes = new float[nlev+1];

if (bornes == NULL)  return;
type = typ;  nLevel = nlev;
SetLut(min, max, typ);
return;
}

/* --Methode-- */
LUT::~LUT()
{
if (type<0)  return;
delete[] bornes;
}

/* --Methode-- */
void LUT::SetLut(float min, float max, int typ)
{

if ( (typ != kLutType_Lin) && (typ != kLutType_Log) )  typ = kLutType_Lin;
type = typ;
if (max <= min)  max = min+1.;
if (nLevel > 0)
  {
  int i;
  float dx;
  double dlx;
  switch (typ)
    {
    case kLutType_Lin :
      dx = (max-min)/(float)nLevel;
      for(i=0; i<nLevel; i++)
        bornes[i] = min+(float)i*dx;
      break;
    case kLutType_Log :
      dlx = log(max-min) / (float)nLevel;
      for(i=0; i<nLevel; i++)
        bornes[i] = min+(float)exp((double)i*dlx);
      break;
    default:
      for(i=0; i<nLevel; i++)
        bornes[i] = min;
      break;
    }
  bornes[nLevel] = max; 
  }
else  bornes[0] = 0.5*(min+max);
return; 
}

/* --Methode-- */
void LUT::Print()
{
int i;

printf("LUT_Info: Type= %d NLevel= %d Min,Max= %g %g \n",
       type, nLevel, bornes[0], bornes[nLevel]);
for(i=0; i<=nLevel; i++)
  printf("..Bornes[%d] = %g \n", i, bornes[i]);
return;
}

/* --Methode-- */
int LUT::Apply(float x)
{
int i;
for(i=0;i<=nLevel;i++)  
  if (x < bornes[i])  return(i);
return(nLevel+1);
}
