/* Classe pour enrobage generique des widgets Xt, Mac, etc  */
/*                                    Reza 10/95            */

#ifndef PIWDG_X_SEEN
#define PIWDG_X_SEEN

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>

#include "piwdggen.h"

typedef Widget SysDWdg;
typedef WidgetClass SysDWdgClass;


enum WmIntState { k_wmi_unknown=0,
                  k_wmi_normal=1, k_wmi_toplevel=2, 
                  k_wmi_transient=3, k_wmi_override=4,
                  k_wmi_appshell=5 };

class PIWdgX : public PIWdgGen 
{
public:
// Les methodes ...
  PIWdgX(int narg=0, char *arg[]=NULL);
  PIWdgX(PIContainerGen *par, char *nom, 
         int sx=10, int sy=10, int px=0, int py=0);

  virtual ~PIWdgX();

  int CreateXtWdg(char *nom, SysDWdgClass wdgcl=NULL, SysDWdg pwdg=NULL,
                  int sx=10, int sy=10, int px=0, int py=0 );

  virtual void	 FinishCreate(); // apres avoir installe les sous-vues

  virtual void   SetSize(int sx, int sy);
  virtual void   SetPos(int px, int py);
  virtual void   SetBorderWidth(int bw);
  virtual void   SetLabel(string const & lab);
  virtual void   SetBinding(PIBindingKind left, PIBindingKind top, 
                            PIBindingKind right, PIBindingKind bottom);

  virtual int    XSize();
  virtual int    YSize();
  virtual int    XPos();
  virtual int    YPos();
  virtual int    BorderWidth();

  virtual string Nom();  
  virtual void   GetScreenPos(int & spx, int & spy);

  virtual void   Manage();
  virtual void   UnManage();
  virtual bool   IfManaged();
  virtual bool   IsVisible();

//  Gestion de copier-coller
  virtual bool           ClaimSelection(int typ=PICP_string);
  virtual void           SelectionLost();
  virtual int            RequestSelection(int typ=PICP_string);
  virtual void*          ProvideSelection(int& typ, int& len);
  virtual void           PasteSelection(int& typ, void *, int l);

  inline SysDWdg XtWdg() const {return(sdw); }; 
  inline SysDWdg& XtWdg() {return(sdw); }; 

protected:
  int InitXt(int narg=0, char *arg[]=NULL); 


  SysDWdg sdw;
  WmIntState wmis;
  bool stmng;
  
};

typedef PIWdgX PIWdg;


// Utile pour avoir acces au Display et Screen X ...
SysDWdg   PIXtTopWdg();
Display * PIXDisplay();
#define  PIXScreen()  DefaultScreen(PIXDisplay()) 
Time PIXGetLastEventTime();
unsigned long PIXGetLastEventSerial();

#endif/* PIWDGX_SEEN */



