// This may look like C code, but it is really -*- C++ -*-

// Nombres aleatoires pour Peida.

#ifndef PERANDOM_SEEN
#define PERANDOM_SEEN

#include "machdefs.h"
#include <stdlib.h>
#include "histos.h"
#include "nbrandom.h"

class FunRan : public Histo {
public:
  typedef double (*Func)(double);
  FunRan(Func f, float xMin=0.0, float xMax=1.0, int nBin=100);
  FunRan(double *tab, int nBin);
  FunRan(double *tab, int nBin, float xMin, float xMax);
  void IFunRan(double *tab, int nBin);
  double Random(void);
  int BinRandom(void);
};

class FunRan2D EXC_AWARE {
public:
//  typedef double (*Func)(double, double);
//  FunRan2D(Func f, float xMin=0.0, float xMax=1.0, int nBinX=100,
//                   float yMin=0.0, float yMax=1.0, int nBinY=100);
  FunRan2D(double *tab, int nBinX, int nBinY);
  FunRan2D(double **tab, int nBinX, int nBinY);
  ~FunRan2D();
  void Random(double& x, double& y);
  void BinRandom(int& x, int& y);
private:
  FunRan* ranX;
  FunRan** ranY;
  int nx;
};

#endif
