// This may look like C code, but it is really -*- C++ -*-
//--------------------------------------------------------------------------
// File and Version Information:
//      $Id: gaussfilt.h,v 1.4 1999-11-29 14:16:05 ansari Exp $
//
// Description:
//
// History (add to end):
//      Sophie   Oct, 1999  - creation
//
//------------------------------------------------------------------------

#ifndef GAUSSFILT_H_SEEN
#define GAUSSFILT_H_SEEN

//----------------------
// Base Class Headers --
//----------------------
#include "specresp.h"
#include "objfio.h"

//------------------------------------
// Collaborating Class Declarations --
//------------------------------------

//              ---------------------
//              -- Class Interface --
//              ---------------------

// Spectral response in the form  A Exp(-((nu-nu0)/s)^2) 

namespace SOPHYA {

class GaussianFilter:public SpectralResponse
{
public:
  //Constructors
  GaussianFilter ();
  GaussianFilter (double nu0, double s, double a=1., double numin=0., double numax= 9.e49); 
  

  // destructor
  virtual ~GaussianFilter();

  //
  //  Function members
  //

  virtual double transmission(double) const;
  virtual double peakFreq() const;
  virtual double peakTransmission() const;

  virtual void   Print(ostream& os)  const;

  virtual inline double giveNorm() const {return _a;};
  virtual inline double giveNu0() const {return _nu0;};
  virtual inline double giveDNu() const {return _s;};
  virtual void setParams(double nu0, double s, double a=1.);
  
protected:
  double _a, _s, _nu0;
};


  // ObjFileIO<SpecRespVec> pour les PPersist 
  inline POutPersist& operator << (POutPersist& os, GaussianFilter & obj)
    { ObjFileIO<GaussianFilter> fio(&obj); fio.Write(os); return(os);}
  
  inline PInPersist& operator >> (PInPersist& os, GaussianFilter & obj)
    { ObjFileIO<GaussianFilter> fio(&obj); fio.Read(os); return(os);}

};  // End of namespace 

#endif
