// This may look like C code, but it is really -*- C++ -*-
//
// Methode d'ajustement non-lineaire sur des objets 
//                                   R. Ansari    02/2000

#ifndef OBJFITTER_SEEN
#define OBJFITTER_SEEN

#include "machdefs.h"

#include "tmatrix.h"
#include "tvector.h"
#include "generalfit.h"


namespace SOPHYA {

class  ObjectFitter {
public:
  // Residus et fonction fittees sur matrix
  static TMatrix<r_4> FitResidus(TMatrix<r_4> const & mtx, GeneralFit& gfit,
			       double xorg=0.,double yorg=0.,double dx=1.,double dy=1.);
  static TMatrix<r_8> FitResidus(TMatrix<r_8> const & mtx, GeneralFit& gfit,
			       double xorg=0.,double yorg=0.,double dx=1.,double dy=1.);
  static TMatrix<r_4> FitFunction(TMatrix<r_4> const & mtx, GeneralFit& gfit,
			       double xorg=0.,double yorg=0.,double dx=1.,double dy=1.);
  static TMatrix<r_8> FitFunction(TMatrix<r_8> const & mtx, GeneralFit& gfit,
			       double xorg=0.,double yorg=0.,double dx=1.,double dy=1.);
  // Residus et fonction fittees sur vecteurs
  static TVector<r_4> FitResidus(TVector<r_4> const & vec, GeneralFit& gfit,
			       double xorg=0.,double dx=1.);
  static TVector<r_8> FitResidus(TVector<r_8> const & vec, GeneralFit& gfit,
			       double xorg=0.,double dx=1.);
  static TVector<r_4> FitFunction(TVector<r_4> const & vec, GeneralFit& gfit,
				double xorg=0.,double dx=1.);
  static TVector<r_8> FitFunction(TVector<r_8> const & vec, GeneralFit& gfit,
				double xorg=0.,double dx=1.);
};

//  Classe template pour ajustement sur tableaux (Vecteurs, Matrices)
template <class T>
class  ArrayFitter {
public:

  // Residus et fonction fittees sur matrix
  static TMatrix<T> FitResidus(TMatrix<T> const & mtx, GeneralFit& gfit,
			       double xorg=0.,double yorg=0.,double dx=1.,double dy=1.);
  static TMatrix<T> FitFunction(TMatrix<T> const & mtx, GeneralFit& gfit,
				double xorg=0.,double yorg=0.,double dx=1.,double dy=1.);

  // Residus et fonction fittees sur vecteurs
  static TVector<T> FitResidus(TVector<T> const & vec, GeneralFit& gfit,
			       double xorg=0.,double dx=1.);
  static TVector<T> FitFunction(TVector<T> const & vec, GeneralFit& gfit,
				double xorg=0.,double dx=1.);
  
};

}  // Fin du namespace


#endif   // ARRFITTER_SEEN
