#ifndef PIHISTO2D_H
#define PIHISTO2D_H

#include "histos2.h"
#include "piscdrawwdg.h"

class PIHisto2D : public PIScDrawer {
public:
                     PIHisto2D(Histo2D* histo, bool ad=false);
  virtual            ~PIHisto2D();
          void       UseColors(bool fg=false, CMapId cmap=CMAP_GREYINV32);
  virtual void       Draw(PIGraphicUC* g, float xmin, float ymin, float xmax, float ymax);
  virtual void       UpdateSize();
  virtual void       DrawStats(PIGraphicUC* g);
  inline  Histo2D*   Histogram() { return(mHisto); }

protected:
  Histo2D* mHisto;
  bool mFgCol;
  CMapId mCmap;
};

class PIH2DWdg : public PIScDrawWdg {
public:
                     PIH2DWdg(PIContainerGen *par, char *nom, int sx=300, int sy=300, 
                              int px=0, int py=0);
                     ~PIH2DWdg();

  virtual void       Process(PIMessage msg, PIMsgHandler* sender, void* data=NULL);
  void               SetHisto(Histo2D* histo, bool fg=false, CMapId cmap=CMAP_GREYINV32);


  virtual string     GetClickText(float x, float y); 
  virtual void       But3Press(int x, int y);

protected:
  PIHisto2D*  mPih;

};

#endif
