// Classe d'initialisation du module TArray (template Arrays)
#include "machdefs.h"
#include "tarrinit.h"

#include "tmatrix.h"
#include "tvector.h"


int TArrayInitiator::FgInit = 0;

TArrayInitiator::TArrayInitiator()
  : SophyaInitiator()
{
  FgInit++;
  if (FgInit > 1)  return;

//   Enregistrement des classes PPersist du modules TArray
  

  PPRegister(FIO_TMatrix<uint_1>);
  PPRegister(FIO_TMatrix<uint_2>);
  PPRegister(FIO_TMatrix<int_2>);
  PPRegister(FIO_TMatrix<int_4>);
  PPRegister(FIO_TMatrix<int_8>);
  PPRegister(FIO_TMatrix<uint_8>);
  PPRegister(FIO_TMatrix<r_4>);
  PPRegister(FIO_TMatrix<r_8>);
  PPRegister(FIO_TMatrix< complex<r_4> >);
  PPRegister(FIO_TMatrix< complex<r_8> >);

  PPRegister(FIO_TVector<uint_1>);
  PPRegister(FIO_TVector<uint_2>);
  PPRegister(FIO_TVector<int_2>);
  PPRegister(FIO_TVector<int_4>);
  PPRegister(FIO_TVector<int_8>);
  PPRegister(FIO_TVector<uint_8>);
  PPRegister(FIO_TVector<r_4>);
  PPRegister(FIO_TVector<r_8>);
  PPRegister(FIO_TVector< complex<r_4> >);
  PPRegister(FIO_TVector< complex<r_8> >);



}

TArrayInitiator::~TArrayInitiator()
{
  FgInit--;
}


// On met un objet initiator en statique, pour les loaders qui savent 
// appeler le constructeur des objets statiques   Reza 08/98
static TArrayInitiator tarrayinit;

