// $Id: tvector.cc,v 1.1.1.1 2000-03-02 16:48:24 ansari Exp $
//                         C.Magneville          04/99
#include "machdefs.h"
#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <complex>
#include "pexceptions.h"
#include "tvector.h"
#include "objfio.h"

template <class T>
TVector<T>::TVector(uint_4 n)
// Constructeur d'un vecteur de "n" elements
: TMatrix<T>(n,1)
{
}

template <class T>
TVector<T>::TVector(uint_4 n, T* values,Bridge* br)
// Construit un vecteur de n elements. On fournit
// le tableau des valeurs et eventuellement un Bridge.
: TMatrix<T>(n,1,values,br)
{
}

template <class T>
TVector<T>::TVector(const TVector<T>& v)
// Constructeur par copie (partage si "v" temporaire).
: TMatrix<T>(v)
{
}

template <class T>
TVector<T>::TVector(const TVector<T>& v,bool share)
// Constructeur par copie avec possibilite de forcer le partage ou non.
: TMatrix<T>(v,share)
{
}

template <class T>
TVector<T>::TVector(const TMatrix<T>& a)
// Constructeur a partir d'une matrice "a" de dimension (n,1)
: TMatrix<T>(a)
{
if(a.NCols() != 1)
  throw(SzMismatchError("TVector(const TMatrix<T>& a) size mismatch, ncol!=1"));
}


///////////////////////////////////////////////////////////
// --------------------------------------------------------
//   Les objets delegues pour la gestion de persistance 
// --------------------------------------------------------
///////////////////////////////////////////////////////////

template <class T>
FIO_TVector<T>::FIO_TVector()
{
dobj=new TVector<T>;
ownobj=true;
}

template <class T>
FIO_TVector<T>::FIO_TVector(string const & filename) 
{
dobj=new TVector<T>;
ownobj=true; 
Read(filename);
}

template <class T>
FIO_TVector<T>::FIO_TVector(const TVector<T> & obj) 
{ 
dobj = new TVector<T>(obj);
ownobj=true; 
}

template <class T>
FIO_TVector<T>::FIO_TVector(TVector<T> * obj) 
{ 
dobj = obj;
ownobj=false; 
}

template <class T>
FIO_TVector<T>::~FIO_TVector()
{
if (ownobj && dobj) delete dobj;
}

template <class T>
AnyDataObj* FIO_TVector<T>::DataObj()
{
return(dobj);
}

template <class T>
void FIO_TVector<T>::SetDataObj(AnyDataObj & o)
{
TVector<T> * po = dynamic_cast< TVector<T> * >(&o);
if (po == NULL) return;
if (ownobj && dobj) delete dobj;
dobj = po; ownobj = false;
} 

template <class T>
void FIO_TVector<T>::ReadSelf(PInPersist& is)
{
// On lit les 3 premiers uint_4
//  0: Numero de version,  1 : NRows=NElts,  2 : NCol=1
uint_4 itab[3];
is.Get(itab,3);
if (dobj == NULL) dobj = new TVector<T>(itab[1]);
else dobj->ReSize(itab[1]);
// On lit le NDataBlock
FIO_NDataBlock<T> fio_nd(&dobj->DataBlock());
fio_nd.Read(is);
}

template <class T>
void FIO_TVector<T>::WriteSelf(POutPersist& os) const
{
if (dobj == NULL)   return;
//  On ecrit 3 uint_4 .... 
//  0: Numero de version,  1 : NRows=NElts,  2 : NCol=1
uint_4 itab[3];
 itab[0] = 1;  // Numero de version a 1
itab[1] = dobj->NElts();
itab[2] = 1;
os.Put(itab,3);
// On ecrit le NDataBlock
FIO_NDataBlock<T> fio_nd(&dobj->DataBlock());
fio_nd.Write(os);
}

///////////////////////////////////////////////////////////////
#ifdef __CXX_PRAGMA_TEMPLATES__
#pragma define_template TVector<uint_1>
#pragma define_template TVector<uint_2>
#pragma define_template TVector<int_2>
#pragma define_template TVector<int_4>
#pragma define_template TVector<int_8>
#pragma define_template TVector<uint_4>
#pragma define_template TVector<uint_8>
#pragma define_template TVector<r_4>
#pragma define_template TVector<r_8>
#pragma define_template TVector< complex<r_4> > 
#pragma define_template TVector< complex<r_8> > 
// Instances des delegues FileIO (PPersist)
#pragma define_template FIO_TVector<uint_1>
#pragma define_template FIO_TVector<uint_2>
#pragma define_template FIO_TVector<int_2>
#pragma define_template FIO_TVector<int_4>
#pragma define_template FIO_TVector<int_8>
#pragma define_template FIO_TVector<uint_4>
#pragma define_template FIO_TVector<uint_8>
#pragma define_template FIO_TVector<r_8>
#pragma define_template FIO_TVector<r_4>
#pragma define_template FIO_TVector< complex<r_4> >
#pragma define_template FIO_TVector< complex<r_8> >
#endif

#if defined(ANSI_TEMPLATES) || defined(GNU_TEMPLATES)
template class TVector<uint_1>;
template class TVector<uint_2>;
template class TVector<int_2>;
template class TVector<int_4>;
template class TVector<int_8>;
template class TVector<uint_4>;
template class TVector<uint_8>;
template class TVector<r_4>;
template class TVector<r_8>;
template class TVector< complex<r_4> >;
template class TVector< complex<r_8> >;
// Instances des delegues FileIO (PPersist)
template class FIO_TVector<uint_1>;
template class FIO_TVector<uint_2>;
template class FIO_TVector<int_2>;
template class FIO_TVector<int_4>;
template class FIO_TVector<int_8>;
template class FIO_TVector<uint_4>;
template class FIO_TVector<uint_8>;
template class FIO_TVector<r_8>;
template class FIO_TVector<r_4>;
template class FIO_TVector< complex<r_4> >;
template class FIO_TVector< complex<r_8> >;
#endif
