#ifndef UNITVECTOR_H_SEEN
#define UNITVECTOR_H_SEEN

#include <iostream.h>
#include <stdio.h>
#include <string.h>
#include "vector3d.h"

class UnitVector : public Vector3d 
{
  
 public:
  
  UnitVector();
  UnitVector(double x, double y, double z);
  UnitVector(double theta, double phi=0);
  UnitVector(const Vector3d&);
  
  /*virtual*/ Vector3d& operator=(const Vector3d&);  //$CHECK$ EA 101299 operator = non virtual
  virtual Vector3d& operator+=(const Vector3d&);
  virtual Vector3d& operator-=(const Vector3d&);
  virtual Vector3d operator+(const Vector3d&) const;
  virtual Vector3d operator-(const Vector3d&) const;

  virtual Vector3d& operator+=(double d) { return Vector3d::operator+= (d); }
  virtual Vector3d operator+(double d) const { return Vector3d::operator+ (d); }
  virtual Vector3d operator-(double d) const { return Vector3d::operator- (d); }

  void Print(ostream& os) const;
  
};

#endif


