// Classe d'initialisation du module Outils++ 
#include <unistd.h>

#include "skymapinit.h"
#include "spherethetaphi.h"
#include "spheregorski.h"
#include "localmap.h"

int SkyMapInitiator::FgInit = 0;

SkyMapInitiator::SkyMapInitiator()
  : TArrayInitiator()
{
  SkyMapInitiator::FgInit++;
  if (SkyMapInitiator::FgInit > 1)  return;

//   Enregistrement des classes PPersist du modules Outils++
  
  PPRegister(FIO_SphereCoordSys);

  PPRegister(FIO_SphereThetaPhi<r_4>);
  PPRegister(FIO_SphereThetaPhi<r_8>);
  PPRegister(FIO_SphereThetaPhi< complex<r_4> >);
  PPRegister(FIO_SphereThetaPhi< complex<r_8> >);

  PPRegister(FIO_SphereGorski<r_4>);
  PPRegister(FIO_SphereGorski<r_8>);
  PPRegister(FIO_SphereGorski< complex<r_4> >);
  PPRegister(FIO_SphereGorski< complex<r_8> >);

  PPRegister(FIO_LocalMap<r_4>);
  PPRegister(FIO_LocalMap<r_8>);
  PPRegister(FIO_LocalMap< complex<r_4> >);
  PPRegister(FIO_LocalMap< complex<r_8> >);


}

SkyMapInitiator::~SkyMapInitiator()
{
  SkyMapInitiator::FgInit--;
}


// On met un objet initiator en statique, pour les loaders qui savent 
// appeler le constructeur des objets statiques   Reza 08/98
static SkyMapInitiator s_sskymapinit_;

