#ifndef  FFTWServer_H_SEEN
#define  FFTWServer_H_SEEN

#include "machdefs.h"
#include "fftservintf.h"


// Classe definissant l'interface pour les transformees de Fourier 
// L'implementation par defaut est vide et lance une exception 

class FFTWServerPlan;

class FFTWServer : public FFTServerInterface {
 public:
  FFTWServer();
  virtual ~FFTWServer();

  
  virtual FFTServerInterface * Clone();

  // Transformee unidimensionnelle
  virtual void FFTForward(TVector< complex<double> > const & in, TVector< complex<double> > & out);
  virtual void FFTBackward(TVector< complex<double> > const & in, TVector< complex<double> > & out);
  virtual void FFTForward(TVector< double > const & in, TVector< complex<double> > & out);
  virtual void FFTBackward(TVector< complex<double> > const & in, TVector< double > & out);

  // Transforme 2D
  virtual void FFTForward(TMatrix< complex<double> > const & in, TMatrix< complex<double> > & out);
  virtual void FFTBackward(TMatrix< complex<double> > const & in, TMatrix< complex<double> > & out);
  virtual void FFTForward(TMatrix< double > const & in, TMatrix< complex<double> > & out);
  virtual void FFTBackward(TMatrix< complex<double> > const & in, TMatrix< double > & out);

// Methodes statiques pour reordonner les donnees 
  virtual void ReShapetoReal( TVector< complex<r_8> > const & in, TVector< r_8 >  & out);
  virtual void ReShapetoCompl(TVector< r_8 > const & in, TVector< complex<r_8> > & out);

 protected:
 FFTWServerPlan * _p1df;
 FFTWServerPlan * _p1db;
 FFTWServerPlan * _p2df;
 FFTWServerPlan * _p2db;

 FFTWServerPlan * _p1drf;
 FFTWServerPlan * _p1drb;
 FFTWServerPlan * _p2drf;
 FFTWServerPlan * _p2drb;
};

#endif
