//     Persistence manager for template numerical arrays
//               R. Ansari, C.Magneville   03/2000

#include "pexceptions.h"
#include "fioarr.h"

// --------------------------------------------------------
//   Les objets delegues pour la gestion de persistance 
// --------------------------------------------------------
///////////////////////////////////////////////////////////

template <class T>
FIO_TArray<T>::FIO_TArray()
{
  dobj=new TArray<T>;
  ownobj=true;
}

template <class T>
FIO_TArray<T>::FIO_TArray(string const & filename) 
{
  dobj=new TArray<T>;
  ownobj=true; 
  Read(filename);
}

template <class T>
FIO_TArray<T>::FIO_TArray(const TArray<T> & obj) 
{ 
  dobj = new TArray<T>(obj);
  ownobj=true; 
}

template <class T>
FIO_TArray<T>::FIO_TArray(TArray<T> * obj) 
{ 
  dobj = obj;
  ownobj=false; 
}

template <class T>
FIO_TArray<T>::~FIO_TArray()
{
  if (ownobj && dobj) delete dobj;
}

template <class T>
AnyDataObj* FIO_TArray<T>::DataObj()
{
  return(dobj);
}

template <class T>
void FIO_TArray<T>::SetDataObj(AnyDataObj & o)
{
  TArray<T> * po = dynamic_cast< TArray<T> * >(&o);
  if (po == NULL) return;
  if (ownobj && dobj) delete dobj;
  dobj = po; ownobj = false;
} 

template <class T>
void FIO_TArray<T>::ReadSelf(PInPersist& is)
{
// On lit les 3 premiers uint_4
//  0: Numero de version,   : NRows,  2 : NCol
  uint_4 itab[5];
  is.Get(itab,5);
  if (dobj == NULL) dobj = new TArray<T>;
// On lit les tailles, etc ...
  is.Get(dobj->ndim_);
  is.Get(dobj->size_, TARRAY_MAXNDIMS);
  is.Get(dobj->totsize_);
  is.Get(dobj->step_, TARRAY_MAXNDIMS);
  is.Get(dobj->minstep_);
  is.Get(dobj->offset_);
  is.Get(dobj->marowi_);
  is.Get(dobj->macoli_);
// On lit le datablock
  is >> dobj->DataBlock();
// On ecrit le DVList info si necessaire
  if (itab[2] != 0)  is >> dobj->Info();  
}

template <class T>
void FIO_TArray<T>::WriteSelf(POutPersist& os) const
{
  if (dobj == NULL)   return;
//  On ecrit 4 uint_4 .... 
//  0: Numero de version,  1 : Type (Array, matrix, Vector, ...)  2 != 0 , has Info
  uint_4 itab[5];
  itab[0] = 1;  // Numero de version a 1
  itab[1] = 0;
  itab[2] = (dobj->mInfo != NULL) ? 1 : 0;
  itab[3] = itab[4] = 0;
  os.Put(itab,3);
// On ecrit les tailles, etc ...
  os.Put(dobj->ndim_);
  os.Put(dobj->size_, TARRAY_MAXNDIMS);
  os.Put(dobj->totsize_);
  os.Put(dobj->step_, TARRAY_MAXNDIMS);
  os.Put(dobj->minstep_);
  os.Put(dobj->offset_);
  os.Put(dobj->marowi_);
  os.Put(dobj->macoli_);
// On ecrit le datablock
  os << dobj->DataBlock();
// On ecrit le DVList info si necessaire
  if (itab[2] != 0)  os << dobj->Info();
}



///////////////////////////////////////////////////////////////
#ifdef __CXX_PRAGMA_TEMPLATES__
// Instances des delegues FileIO (PPersist)
#pragma define_template FIO_TArray<uint_1>
#pragma define_template FIO_TArray<uint_2>
#pragma define_template FIO_TArray<int_2>
#pragma define_template FIO_TArray<int_4>
#pragma define_template FIO_TArray<int_8>
#pragma define_template FIO_TArray<uint_4>
#pragma define_template FIO_TArray<uint_8>
#pragma define_template FIO_TArray<r_8>
#pragma define_template FIO_TArray<r_4>
#pragma define_template FIO_TArray< complex<r_4> >
#pragma define_template FIO_TArray< complex<r_8> >
#endif

#if defined(ANSI_TEMPLATES) || defined(GNU_TEMPLATES)
// Instances des delegues FileIO (PPersist)
template class FIO_TArray<uint_1>;
template class FIO_TArray<uint_2>;
template class FIO_TArray<int_2>;
template class FIO_TArray<int_4>;
template class FIO_TArray<int_8>;
template class FIO_TArray<uint_4>;
template class FIO_TArray<uint_8>;
template class FIO_TArray<r_8>;
template class FIO_TArray<r_4>;
template class FIO_TArray< complex<r_4> >;
template class FIO_TArray< complex<r_8> >;
#endif
