// This may look like C code, but it is really -*- C++ -*-
//      template array class for numerical types
//                     R. Ansari, C.Magneville   03/2000

#ifndef FIOTArray_SEEN
#define FIOTArray_SEEN

#include "machdefs.h"
#include <iostream.h>
#include "tarray.h"
#include "ppersist.h"

namespace SOPHYA {
/////////////////////////////////////////////////////////////////////////
// Classe pour la gestion de persistance
template <class T>
class FIO_TArray : public  PPersist  {
public:
  FIO_TArray();
  FIO_TArray(string const & filename); 
  FIO_TArray(const TArray<T> & obj);
  FIO_TArray(TArray<T> * obj);
  virtual ~FIO_TArray();
  virtual AnyDataObj* DataObj();
  virtual void        SetDataObj(AnyDataObj & o);
  inline operator TArray<T>() { return(*dobj); }
protected :
  virtual void ReadSelf(PInPersist&);           
  virtual void WriteSelf(POutPersist&) const;  
  TArray<T> * dobj;
  bool ownobj;
};

template <class T>
inline POutPersist& operator << (POutPersist& os, TArray<T> & obj)
{ FIO_TArray<T> fio(&obj);  fio.Write(os);  return(os); }
template <class T>
inline PInPersist& operator >> (PInPersist& is, TArray<T> & obj)
{ FIO_TArray<T> fio(&obj);  fio.Read(is);  return(is); }

} // Fin du namespace

#endif
