#include "machdefs.h"

#include <math.h>
#include <iostream.h>

#include "nbrandom.h"
#include "tarrinit.h"
#include "tarray.h"
#include "tvector.h"
#include "timing.h"
#include "intflapack.h"


int main(int narg, char* arg[])
{

  SophyaInit();
  InitTim();   // Initializing the CPU timer


  int n = 5;
  int i,j,k;

  if (narg > 1) n = atoi(arg[1]);
  cout << "rztest_lapack - Size=" << n << endl;
  try {
  TArray<r_4> a(n,n);
  for(i=0; i<n; i++)
    for(j=0; j<n; j++)  a(i,j,0) = GauRnd(0., 1.);
  
  TArray<r_4> x(1,n), b(1,n);
  r_4 sum ;
  for(i=0; i<n; i++) x(0,i,0) = GauRnd(2., 1.5);
  for(i=0; i<n; i++) {
    sum = 0.;
    for(j=0; j<n; j++) sum +=  a(j,i,0)*x(0,j,0);
    b(0,i,0) = sum;
  }

  cout << " ------------ Matrix A = \n " << a << "\n" << endl; 
  cout << " ------------ Matrix X = \n " << x << "\n" << endl; 
  cout << " ------------ Matrix B = \n " << b << "\n" << endl; 

  cout << "\n     Calling rztest_lapack ... " << endl;

  rztest_lapack(a, b);

  cout << " ------------ Result B(=X ?) = \n " << b << "\n" << endl; 

  PrtTim(" End of lpk (rztest_lapack) ");
  }
  catch (PThrowable exc) {
    cerr << " catched Exception (rztest_lapack) " << exc.Msg() << endl;
  }  
  catch (...) {
    cerr << " catched unknown (...) exception (rztest_lapack) " << endl; 
  }  
  
  try {
  cout << "\n -----> Testing TArray <---- " << endl;  
  TArray<int_4> ia(6,4); 
  TArray<int_4> ib(2,3);
  Sequence seq(10., 2.);
  ia = seq;
  ib = 5;
  cout << " ----- matrix IA = \n " << ia << endl;
  cout << " ----- matrix IB = \n " << ib << endl;
  uint_4 pos[5];
  uint_4 sz[5];
  pos[0] = 3;  pos[1] = 1;
  sz[0] = 3;  sz[1] = 2;
  TArray<int_4> ic = ia.SubArray(2, sz, pos);
  cout << " ----- matrix IC IA(3,2,3,1) = \n " << ic << endl;
  ic = 0;
  cout << " ----- matrix IA = \n " << ia << endl;
  }
  catch (PThrowable exc) {
    cerr << " catched Exception " << exc.Msg() << endl;
  }  
  catch (...) {
    cerr << " catched unknown (...) exception " << endl; 
  }  
  cout << " ---------------  END of Programme -------------- " << endl;
}
