#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "pisysdep.h"
#include PIMENU_H
#include "picons.h"


// #define DEBUG_PICONS 1

//  Le menu qui va servir a changer de fontes, couleurs, ...
// de bouton-3
static PIPUMenu* opmc=NULL;
static int nb_opmc = 0;

/*  --------------------------------------------------------------------------------- */
/*  ---------  Classe PIConsole : I/O (Ecriture/lecture) texte standard  ------------ */
/*  --------------------------------------------------------------------------------- */

static int CmdStrLen = 256;

/* --Methode-- */
PIConsole::PIConsole(PIContainer* par, char* nom, PIMessage msg,
                     int nl, int nc, int sx, int sy, int px, int py) :
PIBaseWdg(par, nom, sx, sy, px, py) 
{
mNL = (nl > 10) ? nl : 10;
mNC = (nc > 40) ? nc : 40;
mText = new char[mNL*mNC];
mAtt = new unsigned char[mNL*mNC];
mLPo = new int[mNL];
mStrBuf = new char[mNC+1];
mCmdStr = new char[CmdStrLen+1];
mCCP = mCLC = 0;
mDCOff = 0;
AssocScrollBar(NULL);
SetMsg(msg);
int i;
for(i=0; i<mNL; i++) {
  mLPo[i] = i*mNC;
  ClearLine(i);
  }

mOffL = 0;
mNCmdL = 0;
SetPrompt("Cmd> ");
ClrCmd();
SelectFont();
SelFgBgCol();
mCurL = mNL-mWSzL-1; 
mCurC = 0;

// Pour le menu des options : Fontes, couleur, ...
if (!opmc) {
  opmc = new PIPUMenu((PIMsgHandler *)this, "OptCons");
  opmc->AppendItem("SmallFont", 3101);
  opmc->AppendItem("NormalFont", 3102);
  opmc->AppendItem("LargeFont", 3103);
  opmc->AppendItem("White-Black", 3201);
  opmc->AppendItem("Black-White", 3202);
  opmc->AppendItem("Black-Yellow", 3203);
  }
nb_opmc++;

ActivateKeyboard();
// ActivateButton(1);   Pour permettre la selection 
ActivateButton(3); // Pour afficher le menu des options (Fontes/couleur)
Manage();
return;
}

/* --Methode-- */
PIConsole::~PIConsole()
{
delete[] mText;
delete[] mAtt;
delete[] mLPo;
delete[] mStrBuf;
delete[] mCmdStr;
nb_opmc--;
if (nb_opmc == 0) { delete opmc;  opmc=NULL; }
}

/* --Methode-- */
void PIConsole::AddChar(char c, unsigned char va, bool ref)
{
int l1, l2;
if (mOffL != 0)  // Decalage d'affichage precedant -> Tout rafraichir 
  { l1 = mNL-mWSzL-1; l2 = mNL-1;  SetDispOffset(-1); }
else l1 = l2 = mCurL; 
if (c == '\n') {
  mCurC = 0;
  mCurL++;   
  }
else {
  mText[mLPo[mCurL]+mCurC] = c;
  mAtt[mLPo[mCurL]+mCurC] = va;
  if (++mCurC == mNC) {mCurC = 0;  mCurL++; }
  }

if (mCurL >= (mNL-mNCmdL) ) { // Il faut scroller 
  ScrollUp();
  mCurL = mNL-mNCmdL-1;
  l1 = mNL-mWSzL-1; 
}
if (l2 < mCurL) l2 = mCurL;
if (ref) DisplayLines(mWGrC, l1, l2);
return;
}


/* --Methode-- */
void PIConsole::AddStr(char* strg, unsigned char va, bool ref)
{
int l1, l2;
if (mOffL != 0)  // Decalage d'affichage precedant -> Tout rafraichir 
  { l1 = mNL-mWSzL-1; l2 = mNL-1;  SetDispOffset(-1); }
else l1 = l2 = mCurL; 

char c;
while ( (c = *strg) != '\0') {
  if ( c != '\n' ) {
    mText[mLPo[mCurL]+mCurC] = c;
    mAtt[mLPo[mCurL]+mCurC] = va;
    if (++mCurC == mNC) {mCurC = 0;  mCurL++; }
    }
  else { mCurL++; mCurC = 0; } 
  if (mCurL >= (mNL-mNCmdL) ) { // Il faut scroller 
    ScrollUp();
    mCurL = mNL-mNCmdL-1;
    }
  strg++;
  }

if (l2 < mCurL) l2 = mCurL;
if (ref) DisplayLines(mWGrC, l1, l2);
return;
}

/* --Methode-- */
void PIConsole::SelectFont(PIFontSize sz)
{
int asc, desc;
mWGrC->SelFont(sz);
mFTaille = sz;
mFHaut = mWGrC->GetFontHeight(asc, desc);
mFLarg = mWGrC->CalcStringWidth("A");
mWSzL = YSize()/mFHaut - 1;
mWSzC = XSize()/mFLarg - 1;
mOffL = 0;
if (mScb) {
  mScb->SetMinMax(0, NbLines()-1);
  mScb->SetSize(WindNbLines());
  mScb->SetValue(NbLines()-WindNbLines()-1);
  }
}

/* --Methode-- */
void PIConsole::AcceptCmd(bool acc)
{
int l1, l2;
if (acc) {
  if (mNCmdL)  return;  // Pas de changement d'etat
  if (mCurL == (mNL-1) ) { l1 = mNL-mWSzL-1; ScrollUp(); mCurL = (mNL-2); }
  else l1 = mNL-1;
  mNCmdL = 1;
  ClrCmd();
  UpdCmdLine();
  l2 = mNL-1;
  }
else {
  if (mNCmdL == 0)  return;  // Pas de changement d'etat
  mNCmdL = 0;
  ClearLine(mNL-1);
  ClrCmd();
  l1 = l2 = mNL-1;
  }
DisplayLines(mWGrC, l1, l2);
return;
}

/* --Methode-- */
void PIConsole::SetPrompt(char* prompt)
{
strncpy(mPrompt, prompt, 31);  
mPrompt[31] = '\0';
return;
}

/* --Methode-- */
void PIConsole::SetDispOffset(int ldeb)
{
if (ldeb < 0)    { 
  if (mScb) mScb->SetValue(NbLines()-WindNbLines()-1);
  mOffL = 0;
}
else if (ldeb >= mNL-mWSzL-1)  mOffL = 0;
else mOffL = (mNL-mWSzL-1)-ldeb;
if (mOffL < 0)  mOffL = 0;
}

/* --Methode-- */
void PIConsole::AssocScrollBar(PIScrollBar* scb)
{
mScb = scb;
if (mScb)  { 
  msgScb = mScb->Msg();
  mScb->SetMsgParent(this);
  mScb->SetMinMax(0, NbLines()-1);
  mScb->SetSize(WindNbLines());
  mScb->SetValue(NbLines()-WindNbLines()-1);
  }
else msgScb = 0;
}

/* --Methode-- */
void PIConsole::Resize()
{
mWSzL = YSize()/mFHaut-1;
mWSzC = XSize()/mFLarg-1;
if (mScb) {
  mScb->SetMinMax(0, NbLines()-1);
  mScb->SetSize(WindNbLines());
  mScb->SetValue(NbLines()-WindNbLines()-1);
  }
mOffL = 0;
}

/* --Methode-- */
void PIConsole::Draw(PIGraphicGen* g)
{
EraseWindow();
DisplayLines(g, 0, mNL);
}

static int lines = 0;

/* --Methode-- */
void PIConsole::Keyboard(int key, PIKeyModifier kmod)
{


#ifdef DEBUG_PICONS
if ( (kmod == PIKM_Alt) ) {
  char buff[128];
  int l = 0;
  switch (toupper(key)) {
  case 'P' :
    DebugPrint(1);
    break;
  case 'H' :
    DebugPrint(0);
    break;
  case 'J' :
     AddChar('\n');
    DebugPrint(0);
     break;     
  case 'R' :
    for(l=0; l<1; l++) {
      sprintf(buff, "Line type Reverse No %d ", lines);
      AddStr(buff, PIVA_Reverse, false);
      sprintf(buff, "Normal  ");
      AddStr(buff, PIVA_Def, false);
      sprintf(buff, "Bold  ");
      AddStr(buff, PIVA_Bold, false);
      lines++;
    }   
    Refresh();
    break;
  
  case 'B' :
    for(l=0; l<3; l++) {
      sprintf(buff, "Line type Bold No %d \n", lines);
      AddStr(buff, PIVA_Bold, false);
      lines++;
    }   
    Refresh();
    break;
  
  case 'I' :
    for(l=0; l<3; l++) {
      sprintf(buff, "Line type Italique No %d \n", lines);
      AddStr(buff, PIVA_Ital, false);
      lines++;
    }   
    Refresh();
    break;
  
  case 'N' :
    for(l=0; l<3; l++) {
      sprintf(buff, "Line type Normal No %d \n", lines);
      AddStr(buff, PIVA_Def, false);
      lines++;
    }   
    Refresh();
    break;
  }
}
#endif

if (mNCmdL < 1)  return;

int k;
bool fgfk = false;

if (kmod == PIKM_Cntl) {
  switch (key) {
    case 'A' :
    case 'a' :
      mCCP = 0;
      break;
    case 'E' :
    case 'e' :
      mCCP = mCLC;
      break;
    case 'K' :
    case 'k' :
      mCLC = mCCP;
      break;
    }
  }

else if (kmod == PIKM_Alt) {
  if (key == 'V' || key == 'v') RequestSelection();  // Pour coller (copier/coller)
  }

else if (kmod == PIKM_Blank) {
  switch (key) {
    case PIK_Return :    
    case PIK_Enter :
      mCmdStr[mCLC] = '\0';
//      printf("Process()-Debug- <CR/Enter> CmdStr= %s (L=%d)\n", mCmdStr, strlen(mCmdStr) );
      Send( Msg(), PIMsg_OK, mCmdStr);
      ClrCmd();
      break;

    case PIK_BackSpace :
    case 127 :    // Touche del
    case 8 :      // Touche backspace
      if (mCCP > 0)  { 
        for(k=mCCP-1; k<mCLC-1; k++)  mCmdStr[k] = mCmdStr[k+1];
        mCmdStr[mCLC-1] = ' ';   mCCP--;  mCLC--;
      }
      //      printf("Process()-Debug- Backspace CCP,CLC= %d %d CmdStr= %s (L=%d) \n", mCCP, mCLC, 
      //      mCmdStr, strlen(mCmdStr));
      break;
    case PIK_Left :
      if (mCCP > 0)  mCCP--;
      //      printf("Process()-Debug- Left CCP,CLC= %d %d  \n", mCCP, mCLC);
      break;
    case PIK_Right :
      if (mCCP < mCLC)  mCCP++;
      //      printf("Process()-Debug- Right CCP,CLC= %d %d  \n", mCCP, mCLC);
      break;
    default :
      fgfk = true;
      break;
    }
  }
if ( ( fgfk && (kmod == PIKM_Blank) ) || (kmod == PIKM_Shift)  ) CmdAddChar(key);
UpdCmdLine();
// DisplayLines(mNL-1, mNL-1);
return;
}


/* --Methode-- 
void PIConsole::But1Press(int x, int y)
{
printf("PIConsole::But1Press(%d %d ) \n", x, y);
} */

/* --Methode-- */
void PIConsole::But3Press(int x, int y)
{
opmc->SetMsgParent((PIMsgHandler*)this);
opmc->Show(this, x, y);
}

/* --Methode-- */
void PIConsole::PasteSelection(unsigned int typ, void *pdata, unsigned int l)
{
if (typ != PICP_string) return;
int i;
char *pc = (char *)pdata;
for(i=0; i<l; i++) CmdAddChar(pc[i]);
UpdCmdLine();
}

/* --Methode-- */
void PIConsole::CmdAddChar(int key)
{
  int k, kmx;
  if ( (mCCP < CmdStrLen) && isprint(key) ) {   // Ajout de caracteres
    if (mCCP < mCLC)  { // Insertion au milieu de la chaine
      kmx = (mCLC < CmdStrLen) ? mCLC : CmdStrLen-1;
      //      printf(" ++DBG++ C=%d L=%d MX=%d KMX=%d\n", mCCP, mCLC, CmdStrLen,kmx);
      for(k=kmx; k>mCCP; k--) mCmdStr[k] = mCmdStr[k-1];   mCLC = kmx+1;      
    }
    mCmdStr[mCCP] = key;  mCCP++; 
    if (mCCP > mCLC)  mCLC = mCCP;
    }
}

/* --Methode-- */
void PIConsole::DebugPrint(int lp)
{
printf("PIConsole::DebugPrint() - NL,NC= %d %d - WSzL,C= %d %d Cur= %d %d\n", mNL, mNC, 
        mWSzL, mWSzC, mCurL, mCurC);
printf(" OffL, NCmdL= %d %d - mCCP, mCLC= %d %d - LPo= %d %d \n", 
        mOffL, mNCmdL, mCCP, mCLC, mLPo[mNL-2], mLPo[mNL-1]);

if (lp == 0)  return;
int i,j;
for(j=0; j<mNL; j++) {
  printf("Line[%d] (%d) = ", j, mLPo[j]);
  for(i=0; i<mNC; i++)  putchar(mText[mLPo[j]+i]);
  putchar('\n');
  }
return;
}

/* --Methode-- */
void PIConsole::ScrollUp()
{
int i,l,kpo;
l = mNL-1-mNCmdL;
kpo = mLPo[0];
for(i=0; i<mNL-mNCmdL-1; i++)   mLPo[i] = mLPo[i+1];
mLPo[l] = kpo;
ClearLine(l);
return;
}

/* --Methode-- */
void PIConsole::ClearLine(int l)
{
if ((l<0) || (l >= mNL)) return;
int j;
for(j=0; j<mNC; j++) {
  mText[mLPo[l]+j] = ' ';
  mAtt[mLPo[l]+j] = PIVA_Def;
  }
return;
}

/* --Methode-- */
void PIConsole::DisplayLines(PIGraphicGen* g, int l1, int l2)
{
int j,l,k,l0;
int x,y;

// printf("PIConsole::DisplayLines(%d %d ) \n ", l1, l2);

if (! IsVisible() )   return;

int lva = -1;

PIFontAtt vafat[8] = {PI_RomanFont, PI_BoldFont, PI_ItalicFont,
                      PI_RomanFont, PI_RomanFont, PI_BoldFont, 
                      PI_ItalicFont, PI_RomanFont};
PIColors fgc, bgc;

g->SelForeground(mFgC);
g->SelBackground(mBgC);
fgc =  g->GetForeground();
bgc =  g->GetBackground();

l0 = mNL-mWSzL-1-mOffL;
if (l0 < 0) l0 = 0;
if (l1 < l0) l1 = l0;
if (l2 > mNL-mOffL-1) l2 =  mNL-mOffL-1;

for(l=l1; l<=l2; l++) {
 y = (l-l0+0.5)*mFHaut;
 k = 0;   x = 0.5*mFLarg;
 for(j=0; j<mNC; j++) {
   if (mAtt[mLPo[l]+j] != lva) {
     if (k > 0) {
       mStrBuf[k] = '\0';     
       g->DrawOpaqueString(x, y, mStrBuf);
       //     printf("l,J,K=%d %d %d - X,Y= %d %d - %s \n", l,j,k,x,y,mStrBuf);
       x += k*mFLarg;  k = 0;  
       }
     lva = mAtt[mLPo[l]+j];
     g->SelFont(mFTaille, vafat[lva]);
     if (lva & PIVA_Reverse) { 
       g->SelForeground(bgc);
       g->SelBackground(fgc);
       }
     else  { 
       g->SelForeground(fgc);
       g->SelBackground(bgc);
       }
     }
   mStrBuf[k] = mText[mLPo[l]+j];
   k++;
   }
   if (k > 0) {
     mStrBuf[k] = '\0';     
     g->DrawOpaqueString(x, y, mStrBuf);
     //     printf("l,J,K=%d %d %d - X,Y= %d %d - %s \n", l,j,k,x,y,mStrBuf);
   }
 }

g->SelForeground(fgc);
g->SelBackground(bgc);
return;
}
/* --Methode-- */
void PIConsole::ClrCmd() 
{ 
mCCP = 0; mCLC = 0; mDCOff = 0;
mCmdStr[0] = '\0'; 
}  

/* --Methode-- */
void PIConsole::UpdCmdLine()
{
  char strg[260]; //debug
int l1,l2;
l1 = l2 = mNL-1;
if (mOffL != 0)  // Decalage d'affichage precedant -> Tout rafraichir 
  { l1 = mNL-mWSzL-1; l2 = mNL-1;  SetDispOffset(-1); }

ClearLine(mNL-1);
int j1,j2,j,jj2;
j1 = strlen(mPrompt);
for(j=0; j<j1; j++) {
  mText[mLPo[mNL-1]+j] = mPrompt[j];
  mAtt[mLPo[mNL-1]+j] = PIVA_Bold;
  strg[j] = mPrompt[j];  
  }  
jj2 = mWSzC-j1;
if (mDCOff>=mCCP) mDCOff = 0;
int koff = ((mCCP-mDCOff) >= jj2) ? mCCP-(jj2/2) : mDCOff;
mDCOff = koff;
int kmx = mCLC-koff;
j2 = j1+kmx;
if (j2 > mWSzC)  j2 = mWSzC;
int k = koff;
for(j=j1; j<j2; j++) {
  mText[mLPo[mNL-1]+j] = mCmdStr[k];
  mAtt[mLPo[mNL-1]+j] = PIVA_Def;
  strg[j] = mCmdStr[k];  
  k++;
  }  

strg[j] = '\0';
// printf("UpdCmdLine() %d %d - %s (%d) \n [%d %d %d] %d\n", koff,kmx,strg,j1+mCCP-koff, mWSzC, j1, jj2, mCCP-(jj2/2));
mAtt[mLPo[mNL-1]+j1+mCCP-koff] = PIVA_Reverse;    // Pour le curseur
DisplayLines(mWGrC, l1, l2);

}

/* --Methode-- */
void PIConsole::SelFgBgCol(PIColors fc, PIColors bc)
{
mFgC = fc; mBgC = bc;
SetBackgroundColor(bc);
}

/* --Methode-- */
void PIConsole::Process(PIMessage msg, PIMsgHandler* sender, void* data)
{
int off;
printf("PIConsole::Process() UserMsg()= %d ModMsg= %d \n", (int)UserMsg(msg), 
       (int)ModMsg(msg) );

if (sender == opmc) { // Menu des options 
  bool fgr = true;
  switch (UserMsg(msg)) {
    case 3101 :
      SelectFont(PI_SmallSizeFont);
      break;
    case 3102 :
      SelectFont(PI_NormalSizeFont);
      break;
    case 3103 :
      SelectFont(PI_BigSizeFont);
      break;
    case 3201 :
      SelFgBgCol(PI_Black, PI_White);
      break;
    case 3202 :
      SelFgBgCol(PI_White, PI_Black);
      break;
    case 3203 :
      SelFgBgCol(PI_Yellow, PI_Black);
      break;
    default :
      fgr = false;
      break;
    }
  if (fgr) Refresh();
  }
// Le traitement du scroll-bar
else if ((ModMsg(msg) == PIMsg_DataChanged) && (UserMsg(msg) == msgScb) ) {
  off = (int)data;
  printf(" PIConsole::Process() From ScrollBar : Off=%d \n ", off);
  SetDispOffset(off);
  Refresh();
  }
// Sinon, on retranmet le message
else ReSend(msg, sender, data); 
}

/*  --------------------------------------------------------------------------------- */
/*  --------------   Classe PIScConsole : Console avec ScrollBar  ------------------- */
/*  --------------------------------------------------------------------------------- */

static int Scb_Width = 12;
static int Scb_msg = 400;

/* --Methode-- */
PIScConsole::PIScConsole(PIContainer* par, char* nom, PIMessage msg,
                     int nl, int nc, int sx, int sy, int px, int py) :
PIContainer(par, nom, sx, sy, px, py) 
{
char name[80];
strcpy(name,"TextArea_");
strncat(name, nom, 70);
mCons = new PIConsole(this, name, msg, nl, nc, sx-Scb_Width, sy, 0, 0);
mCons->SetBinding(PIBK_fixed, PIBK_fixed, PIBK_fixed, PIBK_fixed);
strcpy(name,"ScrollBar_");
strncat(name, nom, 70);
mScb = new PIScrollBar (this, name, Scb_msg, true, Scb_Width, sy, sx-Scb_Width, 0);
mScb->SetBinding(PIBK_free, PIBK_fixed, PIBK_fixed, PIBK_fixed);
mCons->AssocScrollBar(mScb);
Show();
}

/* --Methode-- */
PIScConsole::~PIScConsole()
{
delete mCons;
delete mScb;
}

