#ifndef UNIXMAC_SEEN
#define UNIXMAC_SEEN

#include <unix.h>
#include "macshm.h"
#include "sys/types.h"

#ifdef __cplusplus
extern "C" {
#endif

//#define sleep sleep_mac

void InitToolBox();
void yield();
extern int _wakeup;
extern int macSleepTicks;
extern int macRunTicks;

/*typedef long pid_t;*/
#define SIGKILL 9


//int utimes(char* fn, void* tvp);
//unsigned int sleep(unsigned int secs);
char * basename(char * path);

int kill(int , int );  
int link(char* src, char* dst);
int fork(void);

#define ESUCCESS        0               /* Successful */
#define EPERM           1               /* Not owner */
#define ENOENT          2               /* No such file or directory */
#define ESRCH           3               /* No such process */
#define EINTR           4               /* Interrupted system call */
#define EIO             5               /* I/O error */
#define ENXIO           6               /* No such device or address */
#define E2BIG           7               /* Arg list too long */
#define ENOEXEC         8               /* Exec format error */
#define EBADF           9               /* Bad file number */
#define ECHILD          10              /* No children */
#define EDEADLK         11              /* Operation would cause deadlock */
#define ENOMEM          12              /* Not enough core */
#define EACCES          13              /* Permission denied */
#define EFAULT          14              /* Bad address */
#define ENOTBLK         15              /* Block device required */
#define EBUSY           16              /* Mount device busy */
#define EEXIST          17              /* File exists */
#define EXDEV           18              /* Cross-device link */
#define ENODEV          19              /* No such device */
#define ENOTDIR         20              /* Not a directory*/
#define EISDIR          21              /* Is a directory */
#define EINVAL          22              /* Invalid argument */
#define ENFILE          23              /* File table overflow */
#define EMFILE          24              /* Too many open files */
#define ENOTTY          25              /* Not a typewriter */
#define ETXTBSY         26              /* Text file busy */
#define EFBIG           27              /* File too large */
#define ENOSPC          28              /* No space left on device */
#define ESPIPE          29              /* Illegal seek */
#define EROFS           30              /* Read-only file system */
#define EMLINK          31              /* Too many links */
#define EPIPE           32              /* Broken pipe */

extern char* sys_errlist[];

#define F_ULOCK 0       /* Unlock a previously locked region */
#define F_LOCK  1       /* Lock a region for exclusive use */
#define F_TLOCK 2       /* Test and lock a region for exclusive use */
#define F_TEST  3       /* Test a region for other processes locks */

#ifndef _MAXFLOAT
#define _MAXFLOAT
#define MAXFLOAT      ((float)3.40282346638528860e+38)
#endif

struct drand48_data {
	unsigned short	X[3];		/* 48 bit integer value */
	unsigned short	a[3];		/* mutiplier value */
	unsigned short	c;		/* addend value */
	unsigned short	old_X[3];	/* previous value of Xi */
	int		init;		/* initialize ? */
};

extern double	drand48 (void);
extern double	erand48 (unsigned short []);
extern long	jrand48 (unsigned short []);
extern void	lcong48 (unsigned short []);
extern long	lrand48 (void);
extern long	mrand48 (void);
extern long	nrand48 (unsigned short []);
extern unsigned short *seed48 (unsigned short []);
extern void	srand48 (long);

int __drand48_iterate (unsigned short int xsubi[3],struct drand48_data *buffer);

extern int	drand48_r (struct drand48_data *, double *);
extern int	erand48_r (unsigned short [],struct drand48_data *,double*);
extern int	lrand48_r (struct drand48_data *, long *);
extern int	mrand48_r (struct drand48_data *, long *);
extern int	srand48_r (long, struct drand48_data *);
extern int	seed48_r (unsigned short [], struct drand48_data *);
extern int	lcong48_r (unsigned short [], struct drand48_data *);
extern int	nrand48_r (unsigned short [], struct drand48_data *, long*);
extern int	jrand48_r (unsigned short [], struct drand48_data *, long*);

typedef unsigned long long u_int64_t; 

int xccommand(char*** arg);

#ifndef M_PI
#define M_E        2.7182818284590452354E0  /*Hex  2^ 0 * 1.5bf0a8b145769 */
#define M_LOG2E    1.4426950408889634074E0  /*Hex  2^ 0 * 1.71547652B82FE */
#define M_LOG10E   4.3429448190325182765E-1 /*Hex  2^-2 * 1.BCB7B1526E50E */
#define M_LN2      6.9314718055994530942E-1 /*Hex  2^-1 * 1.62E42FEFA39EF */
#define M_LN10     2.3025850929940456840E0  /*Hex  2^ 1 * 1.26bb1bbb55516 */
#define M_PI       3.1415926535897932385E0  /*Hex  2^ 1 * 1.921FB54442D18 */
#define M_PI_2     1.5707963267948966192E0  /*Hex  2^ 0 * 1.921FB54442D18 */
#define M_PI_4     7.8539816339744830962E-1 /*Hex  2^-1 * 1.921FB54442D18 */
#define M_1_PI     3.1830988618379067154E-1 /*Hex  2^-2 * 1.45f306dc9c883 */
#define M_2_PI     6.3661977236758134308E-1 /*Hex  2^-1 * 1.45f306dc9c883 */
#define M_2_SQRTPI 1.1283791670955125739E0  /*Hex  2^ 0 * 1.20dd750429b6d */
#define M_SQRT2    1.4142135623730950488E0  /*Hex  2^ 0 * 1.6A09E667F3BCD */
#define M_SQRT1_2  7.0710678118654752440E-1 /*Hex  2^-1 * 1.6a09e667f3bcd */
#endif

#ifndef _MAXFLOAT
#define _MAXFLOAT
#define MAXFLOAT            ((float)3.40282346638528860e+38)

#endif

#ifdef __cplusplus
}
#endif

#endif
