// This may look like C code, but it is really -*- C++ -*-
//     Utility classes for template numerical arrays 
//                     R. Ansari, C.Magneville   03/2000

#ifndef UtilArray_SEEN
#define UtilArray_SEEN

#include "machdefs.h"
#include <stdlib.h>

namespace SOPHYA {   

/* Quelques utilitaires pour les tableaux (Array) */             

typedef double (* Arr_DoubleFunctionOfX) (double x);
typedef float  (* Arr_FloatFunctionOfX)  (float x);

class Sequence {
public:
  Sequence (double start=0., double step=1., Arr_DoubleFunctionOfX f=NULL);
  inline double & Start() { return start_; }
  inline double & Step() { return step_; }
  double operator () (uint_4 k);
protected:
  double start_, step_;
  Arr_DoubleFunctionOfX myf_;
};

class Range {
public:
  Range(uint_4 start=0, uint_4 size=1, uint_4 step=1);
  inline uint_4 & Start()  {  return start_; }
  inline uint_4 & Size()  {  return size_; }
  inline uint_4 & Step()  {  return step_; }
  Range & operator = (uint_4 start);
protected:
  uint_4 start_, size_, step_;
};

} // Fin du namespace

#endif

