//  Usuall mathematical functions and operations on arrays
//                     R. Ansari, C.Magneville   03/2000

#include "machdefs.h"
#include <stdlib.h>
#include "matharr.h"

// ----------------------------------------------------
//          Application d'une fonction
// ----------------------------------------------------

template <class T>
TArray<T>& MathArray<T>::ApplyFunctionInPlace(TArray<T> & a, Arr_DoubleFunctionOfX f)
{
  T * pe;
  uint_8 j,k;
  if (a.AvgStep() > 0)   {  // regularly spaced elements
    uint_8 step = a.AvgStep(); 
    uint_8 maxx = a.Size()*step;
    pe = a.Data();
    for(k=0; k<maxx; k+=step )  pe[k] = (T)(f((double)pe[k])); 
  }
  else {    // Non regular data spacing ...
    uint_4 ka = a.MaxSizeKA();
    uint_8 step = a.Step(ka);
    uint_8 gpas = a.Size(ka)*step;
    for(j=0; j<a.Size(); j += a.Size(ka))  {
      pe = a.DataBlock().Begin()+a.Offset(j);
      for(k=0; k<gpas; k+=step)  pe[k] = (T)(f((double)pe[k]));
    }
  }
  return(a);
}

template <class T>
TArray<T>& MathArray<T>::ApplyFunctionInPlace(TArray<T> & a, Arr_FloatFunctionOfX f)
{
  T * pe;
  uint_8 j,k;
  if (a.AvgStep() > 0)   {  // regularly spaced elements
    uint_8 step = a.AvgStep(); 
    uint_8 maxx = a.Size()*step;
    pe = a.Data();
    for(k=0; k<maxx; k+=step )  pe[k] = (T)(f((float)pe[k])); 
  }
  else {    // Non regular data spacing ...
    uint_4 ka = a.MaxSizeKA();
    uint_8 step = a.Step(ka);
    uint_8 gpas = a.Size(ka)*step;
    for(j=0; j<a.Size(); j += a.Size(ka))  {
      pe = a.DataBlock().Begin()+a.Offset(j);
      for(k=0; k<gpas; k+=step)  pe[k] = (T)(f((float)pe[k]));
    }
  }
  return(a);
}


template <class T>
TArray<T> MathArray<T>::ApplyFunction(TArray<T> const & a, Arr_DoubleFunctionOfX f)
{
  TArray<T> ra;
  ra = a;
  ApplyFunctionInPlace(ra, f);
  return(ra);
}

template <class T>
TArray<T> MathArray<T>::ApplyFunction(TArray<T> const & a, Arr_FloatFunctionOfX f)
{
  TArray<T> ra;
  ra = a;
  ApplyFunctionInPlace(ra, f);
  return(ra);
}

///////////////////////////////////////////////////////////////
#ifdef __CXX_PRAGMA_TEMPLATES__
#pragma define_template MathArray<r_4>
#pragma define_template MathArray<r_8>
#endif

#if defined(ANSI_TEMPLATES) || defined(GNU_TEMPLATES)
template class MathArray<r_4>;
template class MathArray<r_8>;
#endif
