// This may look like C code, but it is really -*- C++ -*-
//  Usuall mathematical functions and operations on arrays
//                     R. Ansari, C.Magneville   03/2000

#ifndef MathArray_SEEN
#define MathArray_SEEN

#include "machdefs.h"
#include "tarray.h"
#include <math.h>

namespace SOPHYA {

//       Class for simple mathematical operation on arrays 
//   Instanciated only for real and double (r_4, r_8) type arrays 
//                                                Reza 03/2000
template <class T>
class MathArray {
public:
// Applying a function 
  // Replaces the input array content with the result f(x)
  virtual TArray<T>&  ApplyFunctionInPlace(TArray<T> & a, Arr_DoubleFunctionOfX f);
  virtual TArray<T>&  ApplyFunctionInPlace(TArray<T> & a, Arr_FloatFunctionOfX f);
  // Creates a new array and fills it with f(x)
  virtual TArray<T>  ApplyFunction(TArray<T> const & a, Arr_DoubleFunctionOfX f);
  virtual TArray<T>  ApplyFunction(TArray<T> const & a, Arr_FloatFunctionOfX f);
};

////////////////////////////////////////////////
//  Calcul de fonctions usuelles 
template <class T>
inline TArray<T> sin(const TArray<T>& a)
  { MathArray<T> ma;   return( ma.ApplyFunction(a, sin) ); }

template <class T>
inline TArray<T> cos(const TArray<T>& a)
  { MathArray<T> ma;   return( ma.ApplyFunction(a, cos) ); }

template <class T>
inline TArray<T> tan(const TArray<T>& a)
  { MathArray<T> ma;   return( ma.ApplyFunction(a, tan) ); }

} // Fin du namespace

#endif
