#include "machdefs.h"

#include <math.h>
#include <iostream.h>

#include "nbrandom.h"
#include "tarrinit.h"
#include "tarray.h"
#include "tvector.h"
#include "timing.h"
#include "intflapack.h"


int main(int narg, char* arg[])
{

  SophyaInit();
  InitTim();   // Initializing the CPU timer


  int n = 5;
  int i,j,k;

  if (narg > 1) n = atoi(arg[1]);
  cout << "rztest_lapack - Size=" << n << endl;
  try {
  TArray<r_4> a(n,n);
  for(i=0; i<n; i++)
    for(j=0; j<n; j++)  a(i,j,0) = GauRnd(0., 1.);
  
  TArray<r_4> x(n,1), b(n,1);
  r_4 sum ;
  for(i=0; i<n; i++) x(i,0,0) = GauRnd(2., 1.5);
  for(i=0; i<n; i++) {
    sum = 0.;
    for(j=0; j<n; j++) sum +=  a(i,j,0)*x(j,0,0);
    b(i,0,0) = sum;
  }

  cout << " ------------ Matrix A = \n " << a << "\n" << endl; 
  cout << " ------------ Matrix X = \n " << x << "\n" << endl; 
  cout << " ------------ Matrix B = \n " << b << "\n" << endl; 

  cout << "\n     Calling rztest_lapack ... " << endl;

  rztest_lapack(a, b);

  cout << " ------------ Result B(=X ?) = \n " << b << "\n" << endl; 

  PrtTim(" End of lpk (rztest_lapack) ");
  }
  catch (PThrowable exc) {
    cerr << " catched Exception (rztest_lapack) " << exc.Msg() << endl;
  }  
  catch (...) {
    cerr << " catched unknown (...) exception (rztest_lapack) " << endl; 
  }  
  
  cout << " ---------------  END of Programme -------------- " << endl;
}
