#include "machdefs.h"

#include <math.h>
#include <iostream.h>

#include "nbrandom.h"
#include "tarrinit.h"
#include "tarray.h"
#include "matharr.h"
#include "timing.h"


int main(int narg, char* arg[])
{

  SophyaInit();
  InitTim();   // Initializing the CPU timer


  int n = 5;
  int i,j,k;

  if (narg > 1) n = atoi(arg[1]);

  
  try {
  cout << "\n -----> Testing TArray <---- " << endl;  
  // We create a integer array SizeX=7, SizeY=5
  TArray<int_4> ia(7,5); 
  // We fill it with a sequence of numbers starting at 10., with step = 2.
  ia = Sequence(10., 2.);
  cout << " ----- matrix IA = \n " << ia << endl;
  // sub array extraction, Range(2,3) : starting position=2 , size=3
  TArray<int_4> ic = ia(Range(2,3),Range(1,2));
  cout << " ----- matrix IC IA(Range(2,3),Range(1,2)) = \n " << ic << endl;
  // we set the sub-array to zero, this should reflect in the original array
  // sub-arrays share their data with parent array
  ic = 0;
  cout << " ----- matrix IC Apres (=0) = \n " << ic << endl;
  cout << " ----- matrix IA Apres IC=0 = \n " << ia << endl;

  cout << "  :::: 3 Dim arrays ::::: " << endl;
  TArray<int_4>::SetMaxPrint(1000);
  // Creating 3-dim array (X=8 x Y=7 x Z=2) , filling it with 5
  TArray<int_4> ib(8,7,2);
  ib = 5;
  cout << " ----- matrix IB = \n " << ib << endl;
  // Sub array extraction  X from 1 , size 4 - Y from 2 , size 3 , in Z default, from 0, size 1
  // we multiply this sub-array elements by 3
  ib(Range(1,4),Range(2,3)) *= 3;
  cout << " -- matrix IB , Apres ib(Range(1,3),Range(2,1))*=3 : " << endl;
  cout << ib;

  // Creating a double array X=5 x Y=2
  TArray<r_4> fa(5,2);
  // fill it up with a sequence of 0. to 1.
  fa = Sequence(0.,1./(5*2));
  cout << " ------ TArray<r_4> fa(5,2) = \n" << fa << endl;
  // Create a new array from the original array , multiplying it by 2*Pi
  TArray<r_4> fa2 = fa*(float)(2.*M_PI); 
  cout << " ------ TArray<r_4> fa2=fa*2*Pi = \n" << fa2 << endl;
  // Compute sin(fa2) cos(fa2)
  cout << " ------ sin(fa2=fa*2*Pi) = \n" << sin(fa2) << endl;
  cout << " ------ cos(fa2=fa*2*Pi) = \n" << cos(fa2) << endl;
  }
  catch (PThrowable exc) {
    cerr << " catched Exception " << exc.Msg() << endl;
  }  
  catch (...) {
    cerr << " catched unknown (...) exception " << endl; 
  }  
  cout << " ---------------  END of Programme -------------- " << endl;
}
