			// Dominique YVON, CEA/DAPNIA/SPP 02/2000


#include "distribflatfilter.h"

//-------------CC Code--------------------------------------------

//----------------
// Constructor --
//----------------
DistribFlatFilter::DistribFlatFilter(double numin, double numax)
  : SpectralResponse(numin, numax), UnSurdeltaFreq(1./(numax-numin))
{	multFactor=1.;
}

//--------------
// Destructor --
//--------------
DistribFlatFilter::~DistribFlatFilter()
{
}

//              ---------------------------
//              --  Function Definitions --
//              ---------------------------
double DistribFlatFilter::transmission(double nu) const
{
  if(nu>_numin && nu<_numax) return UnSurdeltaFreq*multFactor;
  return 0.;
}


