			// Dominique YVON, CEA/DAPNIA/SPP 02/2000

#ifndef SKYDIPOLE_SEEN
#define SKYDIPOLE_SEEN

#include "lightsrcsep.h"

class LightDipole:public LightSrcDiffBlackBody {
 public:
    LightDipole();
    virtual ~LightDipole() {   };
 protected:
    virtual double DeltaT(double theta,double phi);
// Additional members:
// Cosmic Microwave Background Parameters as measured by COBE and COBRA
    double betaDipole;
    double phiDipole;
    double thetaDipole;
    double vDipole[3];
};

class LightQuadrupole:public LightDipole {
    //strictement identique a Lightdipole sauf processValue()
    //ou on calcule D(T)/T  quadrupolaire
 public:
    LightQuadrupole():LightDipole(){   };
    virtual ~LightQuadrupole() { };
 protected:
     virtual double DeltaT(double theta,double phi);
};

class LightBlackBody:public LightSrcSep {
 public:
    LightBlackBody(double Tempe=T_CMBR, double Resolution=0.);
    virtual ~LightBlackBody() {   };
    
    virtual double powerDensAmpli(double theta,double phi)
    {	return 1.; }
    
    virtual double spectre(double frequence)
    { return planckSpectrum(frequence,TempeCNoir);
    }
 protected:
	double TempeCNoir;
};


class LightNormTCMB:public LightSrcSep {
 public:
    LightNormTCMB(double Tempe=1., double Resol=0.);
    virtual ~LightNormTCMB() {   };
    
    virtual double powerDensAmpli(double theta,double phi)
    {	return 1.; } 	// En Kelvin
    
    virtual double spectre(double frequence)
    {	 return AbsLightSource::planckSpecDiff(DeltaTempeCNoir,frequence,T_CMBR);
    }
    
 protected:
	double DeltaTempeCNoir;
};
#endif
