			// Dominique YVON, CEA/DAPNIA/SPP 02/2000

#ifndef SKYGALAXRESOL_SEEN
#define SKYGALAXRESOL_SEEN

#include "spheregorski.h"
#include "numrecipes.h"
#include "abslightsource.h"

class LightGalaxResol:public AbsLightSource {
 public:
    LightGalaxResol(int_4 nside);
    virtual ~LightGalaxResol();
    virtual double powSpecDens(double theta,double phi,double freq);
    // Return power density at coordinates
    // (W/m2/Hz/St)
    
  	
 // virtual void Reset(const SpectralResponse& Filtre);
    // stocke le flux de puissance (watt/m2/st) pour toutes les sources dans SourcesInBandPower
 protected:
    int_4 nlat;         // Normalement c est 2048!  
    int_4 nbPixelLight; // nbre de pixel de la carte du ciel 
    int_4 nbFreq;       // Nbre de frq ou les sources sont talonnes
    int_4 nbPointSource;// Nbre de sources ponctuelles
    NumRecipes* pNR;
    unsigned long LastFreqIndex;

    r_8* dataFreq;     
    // Tableau des frequences auxquelles sont calcules les cartes guiderdonni
    float* dataFreqDegueux;
    // Idem. Ne sert que pour appeller la fonction NR Polint
    r_4** ppPointSourceData;    // (Jansky, cad 10-26 W/m2/st/Hz)
    //donnes sur chaque source a chaque frequence
    SphereGorski <uint_2>* pLightMap;  
    //grand (!) tableau des pixels du ciel. Contient eventuellement l index de 
    // du tableau SourcesInBandPower, cad le no de la source.
    double MyRan();
};

#endif
