			// Dominique YVON, CEA/DAPNIA/SPP 02/2000

#include <math.h>
#ifdef __MWERKS__
   #include "mwerksmath.h"
   #include "unixmac.h"
#endif
#include "meanlobe.h"



class Lobe4PiGaussien:public MeanFreqLobe 
{ 
 public:
    Lobe4PiGaussien(double FWHM_degre, double freqMin, double freqMax)
      :MeanFreqLobe(freqMin,freqMax){
		sigma=minToRad(FWHM_degre/2.354*60.);
		angleMax=M_PI;
		cosanglemax=cos(angleMax);
		sprintf(Name, "Lobe 4Pi Gaussien");
    }
    virtual ~Lobe4PiGaussien(){ };
   	virtual double weigthAmpl(const UnitVector& VInteg, const UnitVector& VP, 
  	  const UnitVector& VY) const {
		double ang= acos(VP*VInteg);
		return exp(-ang*ang/(2*sigma*sigma));
	}
	virtual double lobeResol() const{
		return sigma*2.354/3.; // On veut pixeliser/calculer  au moins FWHM/3.
	} 
	virtual double ResolutionCurve(double angleShift) const{
		return (double) (1.+(angleShift/sigma/7.));
	}
	
 protected: 
    double sigma;
};
