			// Dominique YVON, CEA/DAPNIA/SPP 02/2000

#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include "makebolotimeline.h"
#include "bruit.h"
//#include "fitsio.h"

#ifdef __MWERKS__
   #include "macenvvariables.h"
   #define SetNlatLSource (256)		// version debug
   #define NbSAMPLE (2000)			//	Pour le debug
#else
   # define ERROR_LABEL -32768
   #define SetNlatLSource (1024)		// version de production CXX
   #define NbSAMPLE (2684300)
#endif


#include "alllobe.h"
#include "alllightsources.h"
#include "sigcalctools.h"
#include "allfilter.h"
#include "fitsioserver.h"



int MakeArcheopsTimelines(char FilePointes[]);
int GenTimLin1_F(long Nbsample, double TStep, float fknee);

int MakeArcheopsTimelines(char FilePointes[])
{

/*

// On genre des timelines de bruit en 1/f
 	GenTimLin1_F(NbSAMPLE,5.83e-3,1.);
 	GenTimLin1_F(NbSAMPLE,5.83e-3,0.5);
 	GenTimLin1_F(NbSAMPLE,5.83e-3,0.1);
*/
 	
// On passe aux cartes de fonds physiques
// Initialisations
   FitsIoServer FitsServer;
   char filename[150]="";
     
//	cerr.setf(ios::scientific);
  	cerr<< "C'est parti"<<endl;
  	
 	// Des Lobes
 	LobeGaussien GLobeTrapChan1(8./60.,75.e9,600.e9);  //degrs, freqmin, Freqmax
 	LobeGaussien GLobeTrapChan2(8./60.,75.e9,600.e9); 
 	LobeGaussien GLobeTrapChan3(8./60.,75.e9,600.e9); 
 	
#ifndef __MWERKS__
/* char* PATHResults=getenv("PATHResults"); 
   char* PATHDataLScr=getenv("PATHDataLScr");   
   char* PATHCarteLobe=getenv("PATHCarteLobe");
*/
  char* PathInstrumentData=getenv("PathInstrumentData");
#endif

 	// Des Filtres
 	sprintf(filename, "%sfiltretrap99chan1.dat",PathInstrumentData);
 	TabulatedFilter FiltreTrapChan1(filename); 	
 	sprintf(filename, "%sfiltretrap99chan2.dat",PathInstrumentData);
 	TabulatedFilter FiltreTrapChan2(filename);
 	sprintf(filename, "%sfiltretrap99chan3.dat",PathInstrumentData);
 	TabulatedFilter FiltreTrapChan3(filename);

/*	
 	// On imprime les filtres
 	ofstream Cfilter1("TraceFiltre1", ios::out);
	FiltreTrapChan1.TraceFiltre(Cfilter1);
	ofstream Cfilter2("TraceFiltre2", ios::out);
	FiltreTrapChan2.TraceFiltre(Cfilter2);
 	ofstream Cfilter3("TraceFiltre3", ios::out);
	FiltreTrapChan3.TraceFiltre(Cfilter3);
*/

// /*
 	// Les Processus Physiques
 	// LightSynchro Synchro(SetNlatLSource);		// Pas pour Archeops
 	LightDiffDust DiffDust(SetNlatLSource);
 	LightCMBPrim CMBPrim(SetNlatLSource);		// Pour debuter
 	// Le bruit reste  chacun de le gnerer
 	LightDipole CMBDipole;
 	
 	// On definit les timeline desirees
 
 	char fileOut[150];	
 	
 	// Bolo 1_1 soit bolo11.
 	sprintf(fileOut, "ASigPred_bolo1_1Dipole");
 	MakeBoloTimeline TL1_1Dipole(fileOut,CMBDipole,GLobeTrapChan1,
 		FiltreTrapChan1,RayleighJeans);

 	sprintf(fileOut, "ASigPred_bolo1_1CMBPrim");
 	MakeBoloTimeline TL1_1CMBPrim(fileOut, CMBPrim,GLobeTrapChan1,
 		FiltreTrapChan1,RayleighJeans);	

 	sprintf(fileOut, "ASigPred_bolo1_1DiffDust");
 	MakeBoloTimeline TL1_1DiffDust(fileOut,DiffDust,GLobeTrapChan1,
 		FiltreTrapChan1,RayleighJeans);

// Bolo 1_3 soit bolo13.
 	sprintf(fileOut, "ASigPred_bolo1_3Dipole");
 	MakeBoloTimeline TL1_3Dipole(fileOut, CMBDipole,GLobeTrapChan1,
 		FiltreTrapChan1,RayleighJeans);

 	sprintf(fileOut, "ASigPred_bolo1_3CMBPrim");
 	MakeBoloTimeline TL1_3CMBPrim(fileOut, CMBPrim,GLobeTrapChan1,
 		FiltreTrapChan1,RayleighJeans);	

 	sprintf(fileOut, "ASigPred_bolo1_3DiffDust");
 	MakeBoloTimeline TL1_3DiffDust(fileOut,DiffDust,GLobeTrapChan1,
 		FiltreTrapChan1,RayleighJeans);
 		
 	// Bolo 2_4 soit bolo9.
 	sprintf(fileOut, "ASigPred_bolo2_4Dipole");
 	MakeBoloTimeline TL2_4Dipole(fileOut, CMBDipole,GLobeTrapChan1,
 		FiltreTrapChan1,RayleighJeans);

 	sprintf(fileOut, "ASigPred_bolo2_4CMBPrim");
 	MakeBoloTimeline TL2_4CMBPrim(fileOut, CMBPrim,GLobeTrapChan1,
 		FiltreTrapChan1,RayleighJeans);	
 		
 	sprintf(fileOut, "ASigPred_bolo2_4DiffDust");
 	MakeBoloTimeline TL2_4DiffDust(fileOut,DiffDust,GLobeTrapChan1,
 		FiltreTrapChan1,RayleighJeans);
 		
 	// Bolo 2_5 soit bolo4.
 	sprintf(fileOut, "ASigPred_bolo2_5Dipole");
 	MakeBoloTimeline TL2_5Dipole(fileOut, CMBDipole,GLobeTrapChan1,
 		FiltreTrapChan1,RayleighJeans);

 	sprintf(fileOut, "ASigPred_bolo2_5CMBPrim");
 	MakeBoloTimeline TL2_5CMBPrim(fileOut, CMBPrim,GLobeTrapChan1,
 		FiltreTrapChan1,RayleighJeans);	

 	sprintf(fileOut, "ASigPred_bolo2_5DiffDust");
 	MakeBoloTimeline TL2_5DiffDust(fileOut,DiffDust,GLobeTrapChan1,
 		FiltreTrapChan1,RayleighJeans);
 				
 	// Bolo 3_6 soit bolo15.
 	sprintf(fileOut, "ASigPred_bolo3_6Dipole");
 	MakeBoloTimeline TL3_6Dipole(fileOut, CMBDipole,GLobeTrapChan1,
 		FiltreTrapChan1,RayleighJeans);
 	
	sprintf(fileOut, "ASigPred_bolo3_6CMBPrim");
 	MakeBoloTimeline TL3_6CMBPrim(fileOut, CMBPrim,GLobeTrapChan1,
 		FiltreTrapChan1,RayleighJeans);	

 	sprintf(fileOut, "ASigPred_bolo3_6DiffDust");
 	MakeBoloTimeline TL3_6DiffDust(fileOut,DiffDust,GLobeTrapChan1,
 		FiltreTrapChan1,RayleighJeans);
 		
 		
 	// Il faut maintenant lire le fichier des pointages
 	
#ifndef __MWERKS__
  char* PathTimeline=getenv("PathTimeline");
#endif

	char FileName[150];
	sprintf(FileName, "%s%s",PathTimeline,FilePointes);
	ifstream InFile(FileName);
	
#ifdef __MWERKS__	
	// Cxx est trop con!
	if (!InFile.is_open()) 
#else
	if (!InFile)
#endif 
	{	cerr<< "Erreur a l'ouverture du fichier de donnees :"<<FileName<< endl;
		exit(-1);
	}

 	long SamplNumber;
 	float alphaBolo2_5,deltaBolo2_5, alphaBolo2_4,deltaBolo2_4,
 		alphaBolo1_1,deltaBolo1_1, alphaBolo1_3,deltaBolo1_3, 
 		alphaBolo3_6, deltaBolo3_6; 
 	char Line[200];
 	
 	int nbParamLu;
 	long compteur=0;
//	On genre les timelines
	while(!InFile.eof())
	{	
	// On lit les directions pointes
		InFile.getline(Line,200);
		nbParamLu=sscanf(Line," %d %f %f %f %f %f %f %f %f %f %f",
			&SamplNumber, &alphaBolo2_5,&deltaBolo2_5, &alphaBolo2_4,&deltaBolo2_4,
 		&alphaBolo1_1,&deltaBolo1_1, &alphaBolo1_3,&deltaBolo1_3, 
 		&alphaBolo3_6, &deltaBolo3_6);
 		if (nbParamLu!=11) {
 			cerr<<" Problme a la lecture du fichier: "<<FileName<<endl;
 			cerr<<" Ligne :"<<compteur<<endl;
 		}
 		
 	// On remplit les fichiers correspondants 
 		TL1_1Dipole.addToStreamArchTOI(alphaBolo1_1,deltaBolo1_1);
 		TL1_1CMBPrim.addToStreamArchTOI(alphaBolo1_1,deltaBolo1_1);
 		TL1_1DiffDust.addToStreamArchTOI(alphaBolo1_1,deltaBolo1_1);
 		
 		TL1_3Dipole.addToStreamArchTOI(alphaBolo1_3,deltaBolo1_3);
		TL1_3CMBPrim.addToStreamArchTOI(alphaBolo1_3,deltaBolo1_3);
 		TL1_3DiffDust.addToStreamArchTOI(alphaBolo1_3,deltaBolo1_3);
 		
 		TL2_4Dipole.addToStreamArchTOI(alphaBolo2_4,deltaBolo2_4);
 		TL2_4CMBPrim.addToStreamArchTOI(alphaBolo2_4,deltaBolo2_4);
 		TL2_4DiffDust.addToStreamArchTOI(alphaBolo2_4,deltaBolo2_4);
 		
 		TL2_5Dipole.addToStreamArchTOI(alphaBolo2_5,deltaBolo2_5);
		TL2_5CMBPrim.addToStreamArchTOI(alphaBolo2_5,deltaBolo2_5);
 		TL2_5DiffDust.addToStreamArchTOI(alphaBolo2_5,deltaBolo2_5);
 		
 		TL3_6Dipole.addToStreamArchTOI(alphaBolo3_6,deltaBolo3_6);
	 	TL3_6CMBPrim.addToStreamArchTOI(alphaBolo3_6,deltaBolo3_6);
 		TL3_6DiffDust.addToStreamArchTOI(alphaBolo3_6,deltaBolo3_6);
 		
 		compteur++;
 		if((compteur%1000)==0)
 		{	double pourcent=100.*compteur/NbSAMPLE;
 			cout<<"Compteur= "<<compteur<<endl;
 			cout<<"Travail effectue a :"<<pourcent<<" %"<<endl;
 		}
	}
	
	#ifndef __MWERKS__
	char* PATHResults=getenv("PATHResults"); 
#endif

	char filecur[150];
	
// On remplit le ReadMe
	sprintf(filecur,"%sArchSigPredTimeLineReadMe",PATHResults);
	ofstream ReadMe(filecur, ios::out|ios::trunc);
	
	ReadMe<<"Files containning timeline stream"<<endl;
	ReadMe<<"Generated using ArchSignalPredictor, D. Yvon /03/2000"<<endl;
	ReadMe<<"Templates used: as provided by R. Teyssier"<<endl;
	ReadMe<<"Resolution of computation: "<< SetNlatLSource <<" Nlat Healpix"<< endl;
	ReadMe<<"Number of consecutive samples generated:"<<compteur<<endl;
	ReadMe<<"Samples with undefined pointing skipped."<<endl;
	ReadMe<<"Dominique Yvon, DAPNIA/SPP, 03/2000"<<endl;
	ReadMe.close();	// J'espere que c'est assez 
	
 	return 0;
}


int GenTimLin1_F(long Nbsample, double TStep, float fknee)
{
#ifndef __MWERKS__
	char* PATHResults=getenv("PATHResults"); 
#endif

	char filecur[150];
	
// On remplit le ReadMe
	sprintf(filecur,"%sTimLineNoisetot%2.2fReadMe", PATHResults,fknee);
	ofstream ReadMe(filecur, ios::out|ios::trunc);
	
	ReadMe<<"File containning noise timeline"<<endl;
	ReadMe<<"Generated using SumNoise et Memnoise of F. Couchot and R. Ansari"<<endl;
	ReadMe<<"Generation of a white noise of sigma=1."<<" Any unit"<<endl;
	ReadMe<<"1/f noise added with knee frequency :"<< fknee<<" Hz"<< endl;
	ReadMe<<"Timestep for generation: "<<TStep<<" Second"<<endl;
	ReadMe<<"Number of consecutive samples generated:"<<Nbsample<<endl;
	ReadMe<<"Dominique Yvon, DAPNIA/SPP, 03/2000"<<endl;
	
	ReadMe.close();	// J'espere que c'est assez 
	
// On bosse
	SumNoise NoiseGen(fknee);

	TVector<float> Array(Nbsample);
	cout<< " vous avez reserv un espace memoire de :"<<Nbsample*sizeof(float)<<endl;
	for(int i=0; i<Nbsample; i++) 
	{	Array(i)= NoiseGen.Noise();
		if((i%1000)==0)	{
			cout<<"GenTimLin1_F, i= "<< i <<endl;
		}
	}
	
// Write my fitFile, Version avec FitsIOServer
	FitsIoServer FitsServer;
	sprintf(filecur,"%sTimLineNoisetot%2.2f.fits",PATHResults,fknee);/* name for new FITS file */
	FitsServer.save(Array,filecur);
     
	return 0;
}