			// Dominique YVON, CEA/DAPNIA/SPP 02/2000

#ifndef SigCalcTools_H
#define SigCalcTools_H

#include "pixelmap.h" 
#include "abslightsource.h"
#include "abslobenopolar.h"
#include "specresp.h"
#include "integ.h"

enum CalcOptions {NonSeparable,AllSeparable,IsLightMapPowerInband};

class SigCalcTool {
friend double SigCalGLFreqFunc1(double freq);
friend double SigCalGLFreqFunc2(double freq);

public:
  SigCalcTool(AbsLightSource* pLSrc, AbsLobeNoPolar* pLobe, SpectralResponse* pFilter);
  ~SigCalcTool() {	delete pIntegrale;}
  
 inline void SetLightScr(AbsLightSource* pLightScr) 
 	// require to rerun SigCalcToolInit
 {	pLSrc=pLightScr;
	delete pIntegrale;
	SigCalcToolInit();
 }
 double compPixel(double theta, double phi);
    // Return power on detector (Watt/m2) for this Lobe and filter
    // Pointing at these ccordinates.
    // Exact if lobes are symmetrical by rotation around pointed axe
  
 double compPixel(UnitVector& VP, UnitVector& VY);
  	// Return power on detector (Watt/m2) for this Lobe and filter
    // Pointing at these ccordinates. with this telescope orientation
    // Exact
 
 double CalcLobeSize(double frequency= -10.);
 // Calcule l'extension spatiale du lobe de cet outil
 // par integration numerique, calquee sur 
 // L'integration spatiale de powerInteg();
 // VALEUR RETOUR EN STERADIAN
 // Doit EVOLUER SI powerInteg CHANGE;
 
 double NormKelvinRayleighJeans();
 	// Compute te normalisation factor to go from Watt/m2 to KelvinRaleighJeans
 	// same computation option than the map options
 	// KelvinRJ/(Watt/m2)
 	
 double NormKelvinCMB();
 	// Compute te normalisation factor to go from Watt/m2 to KelvinCMB
 	// same computation option than the map options
 	// KelvinCMB/(Watt/m2)
 	
// double CalcInBandPower(double theta, double phi);
 	// return pwwer density (W/m2/st) integred over frequency response
 	// of LSource, Filter and Lobe
 	
// Ces fonctions servent au hackingtools. elle palient le fait que je n'ai pas reussi
// A declarer friend la fonction (refu du compilo de donner acces aux variables protected.
// friend void addInInBandPowerMap(PixelMap<double>& Map, SigCalcTool& Tool);
// Ne pas utiliser! 	
 inline AbsLightSource* getpLSrc() const {return pLSrc;}
 inline AbsLobeNoPolar* getpLobe() const {return pLobe;}
 inline SpectralResponse* getpFilter() const {return pFilter;}
 inline CalcOptions getOption() const {return Option;}
 inline double getFreqMin() {return FreqMin;}
 inline double getFreqMax() {return FreqMax;}
 inline double getIntegSpectOverFreq() {return IntegSpectOverFreq;}
 
protected:
 AbsLightSource* pLSrc;
 AbsLobeNoPolar* pLobe;
 SpectralResponse* pFilter;
 CalcOptions Option;	// Used to drives computations optimisations
 GLInteg* pIntegrale;
 
 bool emptySignal;
 double RAngComp;		// angular resolution of computations
 
 double FreqMax;		// Hz
 double FreqMin;		// Hz
 double IntegSpectOverFreq;

 UnitVector VPointe;	// Boresigth du telescope (axe "Z" in Ticra focal plan)
 UnitVector VY;  		// Axe "Y" of telescope ("horizontal") usefull when lobe are not symetrical
 UnitVector VX;			// By rotation around Z axis.
 UnitVector VCur;		// VCur, vecteur courant du calcul.
 void SigCalcToolInit();
 inline double AngResComp(double angle) const;
    // Return current angle resolution of lobe computation 
    // From map resolution lobe parameters. Unit: Radian 
    
 UnitVector VecOrigin(UnitVector VPointe);
    // Define where high resolution computations starts. 
    // Usually, it's where the horns point to
    // Usefull with QuasiPtSources. You then want to compute around the source.
    // Usefull when lobe as offsets in direction, 
    	// Because he is not in the central part of focal plane. (TTicra data)
 
 // Tools dealing with integration over space or frequency or both.  
 double calcPowerDens() const;
  	// compute the power integrated on frequency dependance, (Lobe and LightSource and filter)
    // on pourra en avoir plusieur versions
 
 double powerInteg();
 	// Compute the power recieved by a bolometer (Integration over space)
 	// Pointing towards XX
 	// From a source LSrc, with a lobe parametrised in Lobe, and an additionnal filter Filter
	// WeigthVsFreq

 // Computation tools       
    // Math tools !!!!!!!-------------------------------------------------------
 inline double max(double a, double b)const;
 inline double min(double a, double b)const;
            //compute solid angle between cones of aperture angles ang1 and ang2
 
 inline double diffSolidAng(double ang1,double ang2) const;
};

// Tools for computing Maps
template <class T> void addToSkyMap(PixelMap<T>& Map, SigCalcTool& Tool);
template <class T> void compSkyMap(PixelMap<T>& Map, SigCalcTool& Tool);
template <class T> void addInInBandPowerMap(PixelMap<T>& Map, SigCalcTool& tool);
  	// Exact if lobes are symmetrical by rotation around pointed axe
	// Return a map at the requested resolution and frequency

// Tools for manipulating maps	
template <class T1, class T2> void addMap(PixelMap<T1>& Map, PixelMap<T2>& Map2);
template <class T1, class T2> void substractMap(PixelMap<T1>& Map, PixelMap<T2>& Map2);
template <class T1, class T2> void divMap1WithMap2(PixelMap<T1>& Map, PixelMap<T2>& Map2);
template <class T> void scaleMap(double scalefactor, PixelMap<T>& Map);
template <class T> int MinMaxSigMap(PixelMap<T>& Map, double& Min, 
	double& Max, double& Moy, double& Var);

#endif