// Dominique YVON, CEA/DAPNIA/SPP 02/2000
#include <math.h>
#ifdef __MWERKS__
   #include "mwerksmath.h"
   #include "unixmac.h"
#endif

#include "abslightsource.h"
#include "lsrcradspec.h"



UnitVector AbsLightSource::GetVSrcCenter() {
  	//Make sense only for QuasiPointSource
  		cerr<<"Call for GetVSrcCenter() for a non QuasiPointSource: exit"<<endl;
  		exit(-1);
  		UnitVector vec;
  		return vec;
}

double AbsLightSource::planckSpecDiff(double DTempe, double freq, double Tempe)
 { // W/m2/st/Hz
   double h_kT=4.800e-11/Tempe;
   double prefac= 2*6.626e-34*6.626e-34/(9.e16*1.38e-23*Tempe*Tempe);
   //
   return prefac*pow(freq,4)*exp(h_kT*freq)/pow((exp(h_kT*freq)-1.),2)*DTempe;
}

double AbsLightSource::planckSpectrum(double freq, double Tempe){
   double h_kT=4.800e-11/Tempe;
   double prefac=2.*6.626e-34/9.e16;			//2*h/c^2
   return prefac*freq*freq*freq/(exp(h_kT*freq)-1.);
      // units (J m-3 Hz-1)
      // Very usefull spectrum!
	 	 // W/m2/st/Hz
}

LSrcRadSpec AbsLightSource::getPowerSpec(double theta,double phi) {
  	// Return Object including power spectrum versus frequency in direction theta, phi
  	// (W/m2/Hz/St)  
  	// Not recommended for intensive use. May Be inefficient or inaccurrate
  	return LSrcRadSpec(this, theta, phi); 
}

void AbsLightSource::print(ostream& OutStr) const
{	OutStr<<"Source de lumiere: "<<Name<<endl;
	OutStr<<"Resolution: "<< resolution<<endl;
	return ;
}

