			// Dominique YVON, CEA/DAPNIA/SPP 02/2000

#ifndef FastLOBE_SEEN
#define FastLOBE_SEEN

#include <math.h>
#ifdef __MWERKS__
   #include "mwerksmath.h"
   #include "unixmac.h"
#endif
#include "meanlobe.h"


class LobeGaussien:public MeanFreqLobe 
{ 
 public:
    LobeGaussien(double FWHM_degre, double freqMin, double freqMax)
      :MeanFreqLobe(freqMin,freqMax){
		sigma=minToRad(FWHM_degre/2.354*60.);
		angleMax=3.*sigma;
//		angleMax=1.5*sigma; // BUGG XXXX pour debug
		cosanglemax=cos(angleMax);
		sprintf(Name,"Lobe Gaussien");
    }
    virtual ~LobeGaussien(){ };
   	virtual double weigthAmpl(const UnitVector& VInteg, const UnitVector& VP, 
  	  const UnitVector& VY) const {
   	  	double cosinus=VP*VInteg;		
	    if(cosinus>cosanglemax) 
	    {  if(cosinus<1.) 
	    	{ 	double ang= acos(cosinus);
	    		//return tabFExp(-ang*ang/(2*sigma*sigma));
	       		return exp(-ang*ang/(2*sigma*sigma));
	       	}
	       	else return 1.;
	    }
		else return 0.;
	}
	virtual double lobeResol() const{
		return sigma*2.354/3.; // On veut pixeliser/calculer  au moins FWHM/3.
	} 
	virtual double ResolutionCurve(double angleShift) const{
		return 1.;
		//return (double) (1.+(angleShift/sigma/7.));
	}
 protected: 
    double sigma;
};

class LobeConique:public MeanFreqLobe {
    // Usefull to degrade map resolutions without loosing points objects
 public:
    LobeConique(double halfAngle_degre, double freqMin, double freqMax)    
    	:MeanFreqLobe(freqMin,freqMax){
		halfAng=minToRad(halfAngle_degre*60.);
	//	cosHalfAng=cos(halfAng);
		angleMax=halfAng;
		cosanglemax=cos(halfAng);
		sprintf(Name,"Lobe Conique");
    }
    virtual ~LobeConique() {   }

	virtual double weigthAmpl(const UnitVector& VInteg, const UnitVector& VP, 
  		const UnitVector& VY) const {
		double cosinus=VP*VInteg;
		if(cosinus>cosanglemax) return 1.;
		else return 0.;
	}
   	virtual double lobeResol() const{
		return halfAng/1.5;
   	}
   
   virtual double ResolutionCurve(double angle) const {
    	return 1.;
    }
 protected:
    double  halfAng;    		// demi angle d ouverture du cone
};


#endif
