			// Dominique YVON, CEA/DAPNIA/SPP 02/2000

#include <stdio.h>
#include <stdlib.h>
#include "math.h"

#ifdef __MWERKS__
   #include "mwerksmath.h"
   #include "unixmac.h"
#endif

#include "lightdipole.h"


LightDipole::LightDipole(){
  resolution=0.; // process computed analytically. 
  betaDipole=1.231e-3; 
  phiDipole= 264.31/180.*M_PI;
  thetaDipole= 48.05/180.*M_PI; 
  sprintf(Name, "Dipole du CMB");
  
  cout<<" Creation objet LightDipole" <<endl;

  vDipole[0]= cos(phiDipole)*sin(thetaDipole);
  vDipole[1]= sin(phiDipole)*sin(thetaDipole);
  vDipole[2]= cos(thetaDipole);
}


double LightDipole::DeltaT(double theta,double phi)
{
//Calcule /DT/TCMB apparent du corps noir dans la direction theta, phi
//Peebles and Wilkinson  Phys Rev 174 (1968) 2168
  double vUnit[3];   // Vecteur unitaire correspondant a theta et phi
  double cosinus;    // cosinus de l'angle entre le pointe et VDipole

  vUnit[0]= cos((double)phi)*sin((double)theta);
  vUnit[1]= sin((double)phi)*sin((double)theta);
  vUnit[2]= cos((double)theta);

  cosinus=0.;      //cosinus de l'angle entre le pointe et VDipole
  for (int j=0; j<3; j++) cosinus=cosinus+vUnit[j]*vDipole[j];

  return betaDipole*T_CMBR*cosinus;      // DT/TCMB
}

double LightQuadrupole::DeltaT(double theta,double phi){
  //Calcule /DT/TCMB apparent du corps noir dans la direction theta, phi
  //Peebles and Wilkinson  Phys Rev 174 (1968) 2168
  double vUnit[3];   // Vecteur unitaire correspondant a theta et phi
  double cosinus=0.;  // cosinus de l'angle entre le pointe et VDipole

  vUnit[0]= cos((double)phi)*sin((double)theta);
  vUnit[1]= sin((double)phi)*sin((double)theta);
  vUnit[2]= cos((double)theta);

   //cosinus de l'angle entre le pointe et VDipole
  for (int j=0; j<3; j++) {cosinus+=vUnit[j]*vDipole[j];}

  return betaDipole*betaDipole*T_CMBR*(cosinus*cosinus-0.5);  
                  //DT/TCMB
}

LightBlackBody::LightBlackBody(double TempeCN, double Resol)
	:TempeCNoir(TempeCN) 
{	resolution=Resol;
	sprintf(Name,"CorpsNoirTempe:%5.1f K", TempeCN);
}
	
LightNormTCMB::LightNormTCMB(double DTempe, double Res)
	:DeltaTempeCNoir(DTempe) 
{	resolution=Res;
	sprintf(Name, "Normalisation TCMB");
}