			// Dominique YVON, CEA/DAPNIA/SPP 02/2000

#ifndef SKYGALAXNORESOL_SEEN
#define SKYGALAXNORESOL_SEEN

#include "spheregorski.h"
#include "abslightsource.h"
#include "numrecipes.h"


class LightGalaxNoResol:public AbsLightSource {
 public: 
   LightGalaxNoResol(int_4 nside); 
   virtual ~LightGalaxNoResol(); 
   virtual double powSpecDens(double theta,double phi,double freq);
    // Return power density at coordinates
    // (W/m2/GHz/St)
    
 protected: 
   int_4 nlat;          // Normalement c est 2048! Pas assez de mmoire. 
   int_4 nbPixelLight;  // Carte du ciel complte
   int_4 NbPixUnCote;	//Carte guiderdonni carreesq de NbPixUnCote sur un cote
   int_4 nbFreq; 		  // Nbre de frquences chantillonnes
   int_4 nbPixel;       // Nbre de pixel carte Guiderdonni
   uint_2 nbPixelKept;  // Ce que on peut stocker dans un U2

   NumRecipes* pNR;
   r_8* dataFreq;     
     // Tableau des frequences auxquelles sont calcules les cartes guiderdonni
   float* dataFreqDegueux;
     // Idem. Ne sert que pour appeller la fonction NR Polint
   SphereGorski<uint_2>* pSphereIndex;
     // Tableau de correspondance no de pixel carte sphereGorski, carte guiderdonni

   r_4** ppskyData; // Espace mmoire ncessaire au stockage des cartes partielles
	       		  // Unite Jansky.
   double MyRan();
};

#endif