			// Dominique YVON, CEA/DAPNIA/SPP 02/2000

#ifndef LightSrcSep_H
#define LightSrcSep_H

#include "abslightsource.h"

class LightSrcSep:public AbsLightSource {
 friend class LSrcRadSpecSep;
public: 
  LightSrcSep(){LScrFSep=true; QPtSource=false;}
  ~LightSrcSep() {	}
  virtual double powSpecDens(double theta,double phi,double freq){
    // Return power density at coordinates (W/m2/Hz/St)
  		return spectre(freq)*powerDensAmpli(theta,phi);
  }
  
  virtual double spectre(double frequence)=0; 
        // Return the frequency spectrum independent of coordinates
        // should have no dimension
  virtual double powerDensAmpli(double theta,double phi)=0;
  		// Return power density Amplidude at coordinates
    	// (W/m2/Hz/St)
protected:
};

class LightSrcDiffBlackBody:public LightSrcSep {
	// Classe mettant en oeuvre les sources parametrees 
	// Comme des ecarts de temperature a la tempe du CMB
	// valable dans la limite des petits ecarts de tempe de TCMB
    // DeltaT retourne la DTCMB apparente au point theta, phi.
public:
   LightSrcDiffBlackBody() {
   		h_kT=6.626e-34/T_CMBR/1.38e-23;  // Hz-1
    	Prefac=2*6.626e-34*6.626e-34/(9.e16*1.38e-23*T_CMBR*T_CMBR); 
    	     // 2*h2/(c2*k*TCMB2) ( W/m2/st/Hz^3/K) ou (J/m2/st/Hz^4/K)
   }
   virtual ~LightSrcDiffBlackBody() { };
protected:
	double h_kT;   		// nanosecondes
	double Prefac;
	virtual double DeltaT(double theta,double phi)=0;  	// en Kelvin
    virtual double spectre(double freq){		   		//	Frequence en Hz
		return pow(freq,4)*exp(h_kT*freq)/pow((exp(h_kT*freq)-1),2);
		// Hz^4  
	}	
 	virtual double powerDensAmpli(double theta,double phi){
  		// Return power density Amplidude at coordinates
    	// J/m2/st/Hz^4 ou W/m2/St/Hz^5
       	double PDens= Prefac*DeltaT(theta,phi);
  		return PDens;
    }

};


#endif