			// Dominique YVON, CEA/DAPNIA/SPP 02/2000

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "spheregorski.h"
#include "fitsioserver.h"
#include "lightsynchro.h"

#ifdef __MWERKS__
   #include "mwerksmath.h"
   #include "macenvvariables.h"
#endif

LightSynchro::LightSynchro(int_4 nside) 
{ sprintf(Name, "Lumire Synchrotron");
  freqRef=0.408e9;				// frequence de la carte 0.408 GHz
  index=-0.9;
  nlat=nside;
  if (!(nside==1024)) {
    cerr<<" Fond LightSynchro calcul avec Nside= "<<nside<<endl;
    cerr<<" carte de resolution nside= 1024 disponible"<<endl;
  } 
  
  resolution=2*3.14159/4./nlat;		// Radians
  
  try {	pMap=new SphereGorski<float>(nlat);  }	// MJy/m2/Hz/st cad 10-20 W/m2/Hz/st
  catch(bad_alloc) {
    cerr<<"memory booking error LightSynchro constructor nlat= "<<nlat<<endl;
    exit(-1);
  }
  char filename[150];
#ifndef __MWERKS__
  char *PATHDataLScr=getenv("PATHDataLScr"); 
#endif
  sprintf(filename,"%ssync_res%04i.fits",PATHDataLScr,nside);
  FitsIoServer FitsServer;
  FitsServer.load((*pMap),filename);
    // unite: MJy/m2/Hz/st. 
};

LightSynchro::~LightSynchro() {
  delete pMap;  
}
