			// Dominique YVON, CEA/DAPNIA/SPP 02/2000

#ifndef SKYSYNCHRO_SEEN
#define SKYSYNCHRO_SEEN


#include "lightsrcsep.h"
#include "spheregorski.h"


class LightSynchro:public LightSrcSep{
 public:
 LightSynchro(int_4 nside=256);
 virtual ~LightSynchro();
 protected:
 int_4 nlat;
 double index;
 double freqRef; 
 SphereGorski<float> * pMap; // Map units unknown to be looked for
 
 virtual double spectre(double freq) 
 {
  	return pow(freq/freqRef,index); 		// No dimension
 }
 virtual double powerDensAmpli(double theta,double phi)
 {
   return 2*1.38e-23/(3.e8*3.e8)*freqRef*freqRef*(*pMap)(theta,phi);
  // return 1.e-20*(*pMap)(theta,phi); 	// Ainsi parlait Haslam par Maitre R. Teyssier
      	// (W/m2/Hz/St)  soit du MJ/St	
 }

};


#endif
