			// Dominique YVON, CEA/DAPNIA/SPP 02/2000

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#ifdef __MWERKS__
   #include "mwerksmath.h"
//   #include "unixmac.h"
#endif
#include "strutil.h"
#include "quasiptsources.h" 



QuasiPtSources::QuasiPtSources(double tempe,double angsiz,double theta,double phi)
	:AngSize(angsiz),MyTheta(theta),MyPhi(phi),SurfaceTemperature(tempe)
{
  QPtSource="true";
  resolution=angsiz/1.5;
  h_kT=6.62e-34/1.38e-23/SurfaceTemperature;  				// Dimension 1/Hz
  Prefac=8*M_PI*6.626e-34/9.e16;		// 8*Pi*h/c2 == J m-2 st-1 hz-3
  												// Ou W m-2 st-1 Hz-4
  CosAngSize=cos(AngSize);
  
  pVSource= new UnitVector(MyTheta,MyPhi);
}

QuasiPtSources::~QuasiPtSources(){
  delete pVSource;
}

void QuasiPtSources::SetSourceCoor(double theta,double phi){
  delete pVSource;
  MyTheta=theta; 
  MyPhi=phi;
  pVSource= new UnitVector(MyTheta,MyPhi);
  return;
}

UnitVector QuasiPtSources::GetVSrcCenter()
{  return *pVSource;
} 

double QuasiPtSources::DeltaT(double theta,double phi) {
	// sans dimensions ici
  UnitVector Vec(theta,phi);
  double test1= Vec*GetVSrcCenter();
  if(test1>CosAngSize) return 1.;	
  else return 0;
}

double QuasiPtSources::spectre(double freq){
	// sans dimentions? Oui si on imagine que freq est en Hz!!
	// en Fait Hz^3
	double returnval=freq*freq*freq/(exp(h_kT*freq)-1.);
 	return returnval;
}

