			// Dominique YVON, CEA/DAPNIA/SPP 02/2000

#ifndef SKYQUASIPTSOURCES_SEEN
#define SKYQUASIPTSOURCES_SEEN

#include "lightsrcsep.h"
#include "unitvector.h"

class QuasiPtSources:public LightSrcDiffBlackBody{
 public:
    QuasiPtSources(double tempe=T_CMBR,double angsiz=0.,double theta=0.,double phi=0.);
    // Tempe en Kelvin, angsiz, theta et phi en radian
    // angsiz, demi angle au sommet.
    virtual ~QuasiPtSources();
    void GetSourceCoor(double& theta,double& phi){
	theta=MyTheta; phi=MyPhi; return;}
	
    void SetSourceCoor(double theta,double phi);
    virtual UnitVector GetVSrcCenter(); 
    // Retourne le vecteur unitaire pointant sur la source quasiponctuelle
    double getAngSize() {return AngSize;}
 protected:
    double AngSize;             // Demie taille angulaire en Radian
    double CosAngSize;          // Cosinus de la demi taille angulaire
    double SurfaceTemperature;  // guess! Kelvin
    double MyTheta;             // coordinates on the Sky Radian
    double MyPhi;
    UnitVector* pVSource;          // Direction de la source
    
 // Utilitaires de calcul
 //	double h_kT;
 //	double Prefac;		// 8*pi*h/c2 J m-2 s3
 	
    virtual double spectre(double freq);
    // Nous ne sommes plus dans la limite des petits carts de temperature
    // Surcharge ncessaire
    // GHz 3

    virtual double powerDensAmpli(double theta,double phi) {
  		// Return power density Amplidude at coordinates
    	// W m-2 st-1 GHz-4, Vaut Prefac*DT(theta,phi)
  		double PDens= Prefac*DeltaT(theta,phi);
  		return PDens;
  	}
    double DeltaT(double theta,double phi);
    // Retourne 1. si l on pointe sur la source, 0. sinon
    
    //    virtual double powerInterne(float theta, float phi, DetFilter const& Fil); 
    // return power (Watt/m2/steradian) in direction theta,phi
};
#endif
