#ifndef PIBWDGX_H_SEEN
#define PIBWDGX_H_SEEN

#include "pisysdep.h"
#include "pibwdggen.h"


class PIBaseWdgX : public PIBaseWdgGen
{

public:
// Les methodes ...

                  PIBaseWdgX(PIContainerGen *par, char *nom,
                             int sx=10, int sy=10, int px=0, int py=0);
  virtual         ~PIBaseWdgX();


//  Activation des evenements   
  virtual void   ActivatePtrCross();
  virtual void   ActivateButton(int bid);
  virtual void   ActivateMove(int bid);
  virtual void   ActivateKeyboard();

//  Trace graphiques
  virtual void   EraseWindow();
  virtual void   DrawString(int x, int y, char* s, int pos = 0);
  virtual void   DrawLine(int x1, int y1, int x2, int y2);
  virtual void   DrawBox(int x0, int y0, int dx, int dy);
  virtual void   DrawFBox(int x0, int y0, int dx, int dy);
  virtual void   DrawCircle(int x0, int y0, int r);
  virtual void   DrawFCircle(int x0, int y0, int r);

  virtual void   SelForeground(PIColors col=PI_Black);
  virtual void   SelBackground(PIColors col=PI_White);
  virtual void   SelFont(PIFontSize sz=PI_NormalSizeFont, 
                         PIFontAtt att=PI_RomanFont);
  virtual void   SelFontSzPt(int npt=12, PIFontAtt att=PI_RomanFont);
  virtual void   SelLine(PILineAtt att=PI_NormalLine);
  virtual void   SelPointerShape(PIPointer ptr);
  

  virtual void   Refresh();

// Traitement des evenements   

  virtual void   Resize();
  virtual void   Draw();
  virtual void   Draw(int x0, int y0, int dx, int dy);

  virtual void   Enter();
  virtual void   Leave();  
  virtual void   But1Press(int x, int y);
  virtual void   But1Release(int x, int y);
  virtual void   But2Press(int x, int y);
  virtual void   But2Release(int x, int y);
  virtual void   But3Press(int x, int y);
  virtual void   But3Release(int x, int y);
  virtual void   Ptr1Move(int x, int y);
  virtual void   Ptr2Move(int x, int y);
  virtual void   Ptr3Move(int x, int y);
  virtual void   Keyboard(int key, PIKeyModifier kmod);

  inline  GC     DefGC() { return mDefGC; }

protected:
  void           Init();
  void           SelectFont(int isz, int jat);

  GC mDefGC;
  PIFontAtt mFAtt;
  int mFSize;
};

typedef PIBaseWdgX PIBaseWdg;

#endif /* PIBWDGX_H_SEEN */
