#include<stdio.h>

#include "pisysdep.h"
#include "pioptmenux.h"
#include PICONT_H
#include PISTDWDG_H

#include <Xm/Xm.h>
#include <Xm/RowColumn.h>

/************* PIOptionMenuX ************/


/* --Methode-- */
PIOptMenuX::PIOptMenuX(PIContainerGen* par, PIPUMenu *pum,
                     int sx, int sy, int px, int py)
: PIOptMenuGen(par, pum, sx-2, sy-2, px, py)
{
sx -= 2;
sy -= 2;
SetBorderWidth(1); 
// SetBinding(true, true, true, true);
mAB = new PIButton(this, "?", 0, sy-2, sy-2, 1, 1);
mAB->SetBinding(true, true, false, true);
mAB->SetPressMsg(PIMsg_Press);
mLab = new PILabel(this, "OptLabel", sx-sy-1, sy, sy+1, 0);
mLab->SetBinding(true, true, true, true);
mMen = pum;
SetValue(mMen->ItemMsg(0));
Manage();
}


/* --Methode-- */
PIOptMenuX::~PIOptMenuX()
{
delete mAB;
delete mLab;
}

/* --Methode-- */
void PIOptMenuX::Process(long msg, PIMsgHandler* sender, void* data)
{
// printf("PIOptMenuX::Process Msg= %d Sender= %lx \n", (int)msg, (long)sender);
if ((sender == mAB) && (msg == PIMsg_Press))  
  {  mMen->SetMsgParent(this);    mMen->Show(this, 0, YSize()); }
else if (sender == mMen)
  {
  mAB->ReleaseButton();
  SetValue(msg);
  ReSend(msg, this, data);
  }
return;
}


/* --Methode-- */
void PIOptMenuX::SetValueStr(string & s)
{
int n;
Arg warg[2];
n=mMen->GetNumItem((char *)s.c_str());
if (n < 0)  return;  

XtSetArg(warg[0], XmNmenuHistory, mMen->GetItemWdg(n));
XtSetValues(XtWdg(), warg, 1);
mStext = s;
mSmsg  = mMen->ItemMsg(n);
mLab->SetLabel(mStext);
return;
}

/* --Methode-- */
void PIOptMenuX::SetValue(long msg)
{
int n;
Arg warg[2];
n=mMen->GetNumItemMsg(msg);
if (n < 0)  return;
  
XtSetArg(warg[0], XmNmenuHistory, mMen->GetItemWdg(n));
XtSetValues(XtWdg(), warg, 1);
mStext = mMen->ItemName(n);
mSmsg  = msg;
mLab->SetLabel(mStext);
return;
}

