#include <string.h>

#include "pisysdep.h"

#include PIAPP_H
#include PIWIN_H 
#include PIMENU_H 
#include PIOPTMENU_H 
#include PISTDWDG_H 

#include PIFILECHO_H 

#include "piimage.h"
#include "pihisto.h"
#include "pidrawwin.h"


#define NMXIMG 15   // Nb maxi d'images ouvertes simultanement 

class LutWind;
class UserProcWind;

class PIDemoApp : public PIApplication {
public:
     PIDemoApp(char *path);
     ~PIDemoApp();

     virtual void   Process(long msg, PIMsgHandler* sender, void* data=NULL);

     void SetBusy();
     void SetReady();
     void SetBlocked();
     void AddImage(FitsImageR4 * nouv, string const & name);
     void OpenImage(string const & flnm);
     void CloseCurrent();
     void SaveCurrent(string const & flnm);
     int GetNumCurrent();
     inline PIImage * CurrentPIImage() { return (mCur); }
     FitsImageR4 * CurrentImage();
     PIWindow * CurrentImgWin();

private:
    PIPDMenu  *m[3];
    PIPUMenu *pum[3];
    PIOptMenu * opm[3];
    PILabel *olb[3];
    PIButton * but;
    PIPixmap * zoom;
    PILabel  * labimg, *lab;
    PIFileChooser * pfc;

    PIDrawWindow *  draw;
    PIHisto    *    piHisto;
    Histo*          pixelHisto;
    PIWindow * wpii[NMXIMG];
    PIImage *  pii[NMXIMG];
    FitsImageR4 * img[NMXIMG];
    int mNimg;
    PIImage * mCur;
    int mState;

    LutWind * mLutw;
    UserProcWind * mUP;
    
};

class LutWind : public PIWindow {
public :
  LutWind(PIDemoApp *par);
  ~LutWind();
  virtual void  Show();
  virtual void  Process(long msg, PIMsgHandler* sender, void* data=NULL);

private:
  PIDemoApp * dap;
  PILabel * mLab[2];
  PIButton * mBut[2];
  PIText * mText[2];
  PIPUMenu * mPum[2];
  PIOptMenu * mOpt[2];
  PILabel * mOlb[2];
  
};

class UserProcWind : public PIWindow {
public :
                UserProcWind(PIDemoApp *par);
                ~UserProcWind();
  virtual void  Process(long msg, PIMsgHandler* sender, void* data=NULL);
  void          SelectUP(int n) { mUpr = n; };

private:
  PIDemoApp * dap;
  PILabel  * mLab[3];
  PIButton * mBut[2];
  PIText * mText[3];
  int mUpr;
  
};

