#include "pihisto.h"

PIHisto::PIHisto(Histo* histo)
: PIScDrawer(), mHisto(histo)
{
}

PIHisto::~PIHisto()
{
}

void
PIHisto::AttachTo(PIScDrawWdg* wdg)
{
  PIScDrawer::AttachTo(wdg);
  UpdateSize();
}


void
PIHisto::UpdateSize()
{
  if (!mDrawWdg) return;
  if (mDrawWdg->LimitsFixed()) return;
  // Commencer par trouver nos limites
  
  double xmin = mHisto->XMin();
  double xmax = (mHisto->XMax())*1.2;
  double margeH = (xmax-xmin)/10;
  xmin -= margeH;
  xmax += margeH;

  double ymax = (*mHisto)(mHisto->IMax());
  double margeV = ymax / 10;
  double ymin = -margeV;
  ymax += margeV;
  
  mDrawWdg->SetLimits(xmin, xmax, ymin, ymax);
  mDrawWdg->SetBBoxMargin(margeH, margeV);
}


void
PIHisto::Draw()
{
  if (!mDrawWdg) return;
  mDrawWdg->DrawBBox(1,2,1);
  for (int i=0; i<mHisto->NBins(); i++) {
		double left   = mHisto->BinLowEdge(i);
		double width  = mHisto->BinWidth();
		double bottom = 0;
		double height = (*mHisto)(i);
		mDrawWdg->ScDrawFBox(left,bottom,width,height);
//		mDrawWdg->ScDrawLine(left, bottom, left, bottom + height);
	}
}

void
PIHisto::Refresh()
{
  if (!mDrawWdg) return;
  mDrawWdg->FreeLimits();
  UpdateSize();
  mDrawWdg->Refresh();
}
