#ifndef PISCDRAWWDG_H
#define PISCDRAWWDG_H


#include "pisysdep.h"
#include PIBWDG_H

#include <list.h>

class PIScDrawWdg : public PIBaseWdg {
public:
                     PIScDrawWdg(PIContainerGen *par, char *nom,
                                   int sx=10, int sy=10, int px=0, int py=0);
  virtual           ~PIScDrawWdg();

  virtual void       SetLimits(double xmin, double xmax, double ymin, double ymax, bool tmp=false);
  
  virtual void       ScDrawString(double x, double y, char* s, int pos = 0);
  virtual void       ScDrawLine(double x1, double y1, double x2, double y2);  
  virtual void       ScDrawBox(double x0, double y0, double dx, double dy);
  virtual void       ScDrawFBox(double x0, double y0, double dx, double dy);
  virtual void       ScDrawCircle(double x0, double y0, double r);
  virtual void       ScDrawFCircle(double x0, double y0, double r);

  virtual void       DrawAxes(int tickLevel=1, int markLevel=1);
  virtual void       DrawBBox(int tickLevel=1, int tickFlags=3, int markLevel=1);
  virtual void       SetBBoxMargin(double h, double v);
  
  virtual void       Resize();
  
  virtual void       CalcTicks();
  virtual void       CalcScale();
  
  virtual void       Sc2Local(double x, double y, int& xpix, int& ypix);
  virtual void       Local2Sc(int xpix, int ypix, double& x, double& y);
  virtual void       DSc2Local(double dx, double dy, int& dxpix, int& dypix);
  
  virtual void       Draw();
  
  friend class PIScDrawer;
  virtual void       AddDrawer(PIScDrawer*);   // Ajoute un drawer
  virtual void       RemoveDrawer(PIScDrawer*);  // Ote un drawer sans le detruire
  virtual void       DeleteDrawers();            // Ote et detruit tous les drawers
  static  void       CallDrawer(PIScDrawer*);
  virtual void       CallDrawers();
  virtual void       SetAxesKind(int axesChoice=1, int tickLevel=1, int markLevel=1);
  
  double XMin() const {return xMin;}
  double XMax() const {return xMax;}
  double YMin() const {return yMin;}
  double YMax() const {return yMax;}
  int    LimitsFixed() const {return limitsFixed;}
  void   FreeLimits() {limitsFixed = 0;}
  
  
  virtual void       But2Press(int x, int y);
  virtual void       But2Release(int x, int y);
  virtual void       Ptr2Move(int x, int y);
  
protected:
  double xMin, xMax, yMin, yMax; // Valeurs en unites user
  double xMinS, xMaxS, yMinS, yMaxS; // Sauvegarde pour zoom
  double xOrg, yOrg;             // Position en pixels de (0.0, 0.0)
  double xScale, yScale;         // Pixels par unites graphiques
  double xFirstMajTick, xFirstMinTick;
  double yFirstMajTick, yFirstMinTick;
  double xMajTickStep, xMinTickStep;
  double yMajTickStep, yMinTickStep;
  double xMajTickLen,  xMinTickLen;
  double yMajTickLen,  yMinTickLen;
  
  int limitsFixed;
  int axesChoice, tickChoice, labelChoice;
  double bbmargeh, bbmargev;
  list<PIScDrawer*>   mDrawers;
  
  int xBegDrag, yBegDrag;
  int xEndDrag, yEndDrag;
};

class PIScDrawer {
public:
                     PIScDrawer();
  virtual           ~PIScDrawer();

  virtual void       Draw() = 0;
protected:
  friend class       PIScDrawWdg;
  virtual void       AttachTo(PIScDrawWdg*);
  PIScDrawWdg*       mDrawWdg;
};

class PIScFuncDrawer : public PIScDrawer {
public:
  typedef double(*FUNC)(double);
                     PIScFuncDrawer(FUNC);
  virtual           ~PIScFuncDrawer();
  
  virtual void       Draw();
protected:
  FUNC               mFunc;
};

class GeneralFitFunction;
class PIScGFFDrawer : public PIScDrawer {
public:
                     PIScGFFDrawer(GeneralFitFunction*);
  virtual           ~PIScGFFDrawer();
  
  virtual void       Draw();
  virtual void       SetParms(double const*);
protected:
  GeneralFitFunction* mFunc;
  int                 mNParms;
  double*             mParms;
};


#endif
