// Dominique YVON, CEA/DAPNIA/SPP 02/2000

#ifndef AbsLightSource_H
#define AbsLightSource_H

#include <iostream>
#include "unitvector.h"
#include "radspec.h"
#include "lsrcradspec.h"
#include "specresp.h"

#define T_CMBR (2.726)		 // Kelvin

class AbsLightSource {
//friend class SigCalcTool;
public:
  AbsLightSource() :PtSourceS(false), QPtSource(false), LScrFSep(false), IsLSrcMappedPower (false)
  {	sprintf(Name, "");
  }
  ~AbsLightSource() {	}

  virtual double powSpecDens(double theta,double phi,double freq)=0;
    // Return power density at coordinates
    // (W/m2/Hz/St)
  LSrcRadSpec getPowerSpec(double theta,double phi);
  	// return Object including power spectrum versus frequency in direction theta, phi
  	// (W/m2/Hz/St)  
  	// Not recommended for intensive use. May Be inefficient or inaccurrate..
  	
 //virtual double powerDens(double theta,double phi)=0;
    // Return power Dens at coordinates, integrated over frequency
    // May Require initialisation
    // (Watt/m2/St)
  double LSrcResol() const {
     return resolution;     // constructeur have to initialise res
  }
  
  inline bool IsPtSourceS() { return PtSourceS;}
  inline bool IsQPtSrc() { return QPtSource;} 
  inline bool IsFreqSep() { return LScrFSep;}
  inline bool IsMappedPowerSrc() {return IsLSrcMappedPower;}
  	// Optimisation pour calculs avec Lobes separables facon R. Teyssier
  virtual void print(ostream& OutStr) const;
/*  
  virtual void Reset(const SpectralResponse& Filtre) {
  	cerr<<"you call reset function when not allowed: program exit"<<endl;
  	exit(-1);
  	return;
  }
*/
// Make sense only for QuasiPointSource
  virtual UnitVector GetVSrcCenter(); 
  virtual double getAngSize() {
  	cerr<<"call for getAngSize in a non Quasipt light source"<<endl;
  	exit(-1);
  	return 0;
  }
  
// Optimisation for LightSource separable in frequency
  virtual double spectre(double frequence) {
  	frequence=0;
        // Return the frequency spectrum independent of coordinates
  	cerr<<"call for spectrum in an non separable light source"<<endl;
  	exit(-1);
  	return 0;
  }
  
  virtual double powerDensAmpli(double theta,double phi) {
  	theta=phi; //Pour eviter un warning
  	// Return power density Amplidude at coordinates (W/m2/GHz/St) 
  	cerr<<"call for powerDensAmpli in an non separable LightSource"<<endl;
  	exit(-1);
  	return 0;
  }
  double planckSpectrum(double freq, double Tempe=T_CMBR);
  // W/m2/st/Hz
  double planckSpecDiff(double DTempe, double freq, double Tempe=T_CMBR);
  // W/m2/St/Hz
protected:
  bool PtSourceS;  // Is a set of PtSources (Galaxie IR ponctuelles?)
  bool QPtSource;    // Is this a QuasiPointSource. (Sun, Jupiter, Mars et al.)
  bool LScrFSep;	 // Are spatial coordinated and frequency separable variables?
  bool IsLSrcMappedPower;	// Is the LSrc a in band map power. Valid only for Lobes separabe in freq.
  double resolution; // Map Pixellisation resolution.;
  char Name[32];
};

#endif