			// Dominique YVON, CEA/DAPNIA/SPP 02/2000

#ifndef CARTELOBE_SEEN
#define CARTELOBE_SEEN

#include "abslobenopolar.h"

#define NRANSI
#include "numrecipes.h"
/* Les lobes cartographies ne presentant aucune symetrie spatialle, il est necessaire 
de connaitre l orientation du repere Ticra pour pouvoir calculer dans les lobes. 
Ceci est incompatible avec l'etablissement a priori de carte du ciel mesures. 
Il faut connaitre la strategie de scanning et alors reconstruire les cartes, bref 
faire tout le boulot.
*/

class CarteLobe {
    /* les cartes de lobe centraux sont stockees selon les variables 
       U=sin(alpha)cos(beta)
       V=sin(alpha)sin(beta)  ou alpha et beta sont les angle en coordonnees 
       polaires dans le repere du logiciel TICRA
       Ce sont ces variables qu'il faut passer a la fonction Value pour obtenir
       une reponse coherente
    */
    // On utilise les Numerical Recepies:gestions de tableau particulieres
 public:
    CarteLobe(char fileRoot[]="cartelobevide",double frequence=100.E9,int_4 NbPixelX=100,
    int_4 NbPixelY=100);
    virtual ~CarteLobe();
    void FitsVisu(char FitsFile[],long NbX=300,long NbY=300);
    double Value(double UValue,double VValue) const ;
    // Retourne la valeur de la carte interpole en UValue (X) et en VValue(Y)
    // Echelle lineaire.
    double getFreq() const  { return freq;}
    void UVToAng(double U, double V, double& alpha, double& beta) const;
       //fonction ecrite dans la limite des petits angles
    double UCentre(){return (XMin+XMax)/2.;}
    double VCentre(){return (YMin+YMax)/2.;}
    void UBornes(double& UMin, double& UMax) const { 
	UMin=(double)XMin; UMax=(double)XMax; return;}
    void VBornes(double& VMin, double& VMax) const {
	VMin=(double)YMin; VMax=(double)YMax; return;}
    double halfAngAperture();
	inline double resol() {return resolution;}
 protected:
    //NumRecipes NR;  // pour avoir acces au librairies NR
    long NbPixX;
    long NbPixY;
    float *pAxeX;
    float *pAxeY;

    float XMin, XMax;
    float YMin, YMax;
    float** pCarte;  // Pointeur sur la carte du lobe,facon NR
                     // Les valeurs sont stockees en decibel
    double freq;     // Frequence a laquelle la carte du lobe a ete etablie
    double resolution; //Resolution angulaire de la carte de base

    double CalcResol();
};

#endif
