			// Dominique YVON, CEA/DAPNIA/SPP 02/2000

#ifndef LOBE_CARTO_SEEN
#define LOBE_CARTO_SEEN


#include "unitvector.h"
#include "meanlobe.h"
#include "cartelobe.h"



class LobeCartoMoyen:public MeanFreqLobe{
 public:
    LobeCartoMoyen(CarteLobe* pcart,double freqMin, double freqMax);
    virtual ~LobeCartoMoyen();
    virtual double lobeResol() const;
 private:
    CarteLobe* pCarte;
    virtual UnitVector VecShift(const UnitVector& Vpointe,const UnitVector& VY)const;
    virtual double weigthAmpl(const UnitVector& VInteg, const UnitVector& VP, 
  		const UnitVector& VY) const;
    // return relative weigth of incoming power from direction Vcourant

    // Computes adequate map resolution in radian for this lobe to prevent loss info 
     virtual double ResolutionCurve(double angle) const { return 1.;}
     
};

#endif
