			// Dominique YVON, CEA/DAPNIA/SPP 02/2000

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "lightcmbprim.h"
#include "fitsioserver.h"

#ifdef __MWERKS__
   #include "mwerksmath.h"
   #include "macenvvariables.h"
#endif


LightCMBPrim::LightCMBPrim(int_4 nside)
	:nlat(nside) {

  resolution=2*3.14159/(nlat*4.);  			// Radian
  sprintf(Name, "CMB Primordial");
  cout<<"Objet LightCMBPrim :"<<endl;
  cout<<"Resolution de travail nlat= "<<nlat<<endl;
  
  // On reserve la mmoire pour la carte gorski
  try {
  	pMap =new SphereGorski<float> (nlat);
  }
  catch (bad_alloc) {
  	cerr<<" Memory booking error in LightCMBPrim"<<endl;
  	exit(-1);
  }
  cout<<"Vous avez rserv: "<<12*nlat*nlat*sizeof(float)<<" Octets"<<endl;

  // On lit le fichier gnr par synfast
 			
  char filename[150];  

#ifndef __MWERKS__
  char* PATHDataLScr=getenv("PATHDataLScr"); 
  sprintf(filename,"%s/cmb_res%04i.fits",PATHDataLScr,nlat);
#else
  sprintf(filename,"%scmb_res%04i.fits",PATHDataLScr,nlat); 
#endif

  FitsIoServer FitsServer;
  FitsServer.load(*pMap,filename);	// Units:  Microkelvin
}

LightCMBPrim::~LightCMBPrim() {
	delete pMap;
}

