			// Dominique YVON, CEA/DAPNIA/SPP 02/2000

#include "lightsrcmappowerinband.h"
#include "fitsioserver.h" 

double LightSrcMapPowerInband::powerDensAmpli(double theta,double phi)
{	return (*pMap)(theta,phi);
  		// Return power density Amplidude at coordinates
    	// (W/m2/Hz/st)
}

double LightSrcMapPowerInband::spectre(double freq)
{	if((freq>freqMax)||(freq<freqMin)) return 0.;
    	else return SpectreAmpli;
}

LightSrcMapPowerInband::LightSrcMapPowerInband
	(char filename[],long nside, double MinFreq, double MaxFreq)
  :freqMax(MaxFreq), freqMin(MinFreq), nlat(nside)
{  
   resolution=2*3.14159/4./nlat; // Resolution angulaire de la carte lue pour ce fond.
                      			 // Radians
   SpectreAmpli=1./(freqMax-freqMin);
   if(MinFreq>MaxFreq) cerr<<"Erreur freq Min>freq Max in LightSrcMapPowerInband"<<endl;
   
   try {	pMap=new SphereGorski<float> (nlat);	}
   catch(bad_alloc) {
      cerr<<"Memory booking error LightSrcMapPowerInband, nlat= "<<nlat<<endl;
      exit(-1); 
   }
   cout<<"On lit la carte "<<filename<<endl;  
   FitsIoServer FitsServer;
   FitsServer.load((*pMap),filename);
}

LightSrcMapPowerInband::~LightSrcMapPowerInband()
{	delete pMap;
}
