			// Dominique YVON, CEA/DAPNIA/SPP 02/2000

#include <iomanip.h>
#ifdef __MWERKS__
   #include "macenvvariables.h"
#else
	# define ERROR_LABEL -32768
#endif

#include "makebolotimeline.h"


MakeBoloTimeline::MakeBoloTimeline(char file[], AbsLightSource& LSrc, 
		AbsLobeNoPolar& Lobe, SpectralResponse &Filter, Normalisation Norm)
	:tool(&LSrc,&Lobe,&Filter), NormMethode(Norm)
{
#ifndef __MWERKS__
  char* PATHResults=getenv("PATHResults"); 
#endif
	char filecur[150];
// On remplit le ReadMe
	sprintf(filecur,"%s%s.ReadMe", PATHResults,file);
	cout<<filecur<<endl;
	ofstream ReadMe(filecur,ios::out|ios::trunc);
	
	ReadMe<<" Fichier de timeline pour:"<<endl;
	ReadMe<<" La source physique: "<<endl;
	LSrc.print(ReadMe);
	ReadMe<<" Le Lobe : "<<endl;
	Lobe.print(ReadMe);
	ReadMe<<" Le Filtre: "<<endl;
	Filter.Print(ReadMe);	
	ReadMe<<endl;
	
	NormRJ=tool.NormKelvinRayleighJeans();
	NormTCMB=tool.NormKelvinCMB();
	
//	ReadMe.setf(ios::scientific);
	ReadMe<< setprecision(3);
	ReadMe<<" Constantes de normalisation"<<endl;
	ReadMe<<" RayleighJeans: "<<NormRJ<< " KelvinRJ/(W/m2)"<<endl;
	ReadMe<<" TempeCMB: "<<NormTCMB<< " Kelvin CMB/(W/m2)"<<endl;
	
	ReadMe<<"Cette carte est en unit: ";
	switch(NormMethode)
	{	
		case TempeCMB: 
		{	ReadMe<< "Kelvin CMB"<<endl;
			break;
		}
		case RayleighJeans:
		{ 	ReadMe<< "Kelvin RayleighJeans"<<endl;
			break;
		}
		default: ReadMe<< "Watt/m2 effectif de mirroir"<<endl;
	}
	ReadMe<<"Fichier ecrit selon le format"<<endl;
	ReadMe<<"Radian\tRadian\tAbove Unit"<<endl;
	
	// J'espere que c'est assez 
	ReadMe.close();
	
	sprintf(filecur,"%s%s.dat", PATHResults,file);
	
	pMystr= new ofstream(filecur,ios::out|ios::trunc);
//	pMystr->setf(ios::scientific);
	(*pMystr)<<setprecision(5);
}

void MakeBoloTimeline::addToStreamArchTOI(double theta,double phi)
{	//	 Theta en heures, Phi en degres
	if((theta==ERROR_LABEL)||(phi==ERROR_LABEL)) return;
	double thetaRad=theta*15./180*M_PI;
	double phiRad=phi/180.*M_PI;
	
	addToStream(theta,phi);
}

void MakeBoloTimeline::addToStream(double theta,double phi)
{	// theta et Phi en Radian.	
	switch (NormMethode)
	{
		case RayleighJeans:
		{	double TempeRJ= NormRJ*tool.compPixel(theta,phi);
			(*pMystr)<<theta<<'\t'<<phi<<'\t'<<TempeRJ<<'\n';
			return;
		}
		case TempeCMB:
		{	double tempeCMB= NormTCMB*tool.compPixel(theta,phi);
			(*pMystr)<<theta<<'\t'<<phi<<'\t'<<tempeCMB<<'\n';
			return;
		}
		default:
		{	double power=tool.compPixel(theta,phi);
			(*pMystr)<<theta<<'\t'<<phi<<'\t'<<power<<'\n';
			return;
		}
	}
}
