			// Dominique YVON, CEA/DAPNIA/SPP 02/2000

#ifndef LOBESEP_H
#define LOBESEP_H

#include "abslobenopolar.h"

class LobeSep:public AbsLobeNoPolar {
public:
  LobeSep(double freqMin, double freqMax):AbsLobeNoPolar(freqMin,freqMax) {  LobeFSep=true;}
  ~LobeSep() {	}
  virtual double weigth(const UnitVector& VInteg, const UnitVector& VP, 
  	const UnitVector& VY, double freq) const 
   	// Return relative weigth of incoming power from direction VInteg
    // at frequency freq.
  {  return spectre(freq)*weigthAmpl(VInteg,VP,VY);}
  virtual double spectre(double freq) const=0;
  virtual double weigthAmpl(const UnitVector& VInteg, const UnitVector& VP, 
  	const UnitVector& VY) const=0;
protected:

    // Return relative weigth of incoming power from direction VInteg
    // Averaged on frequency. Mean Lobe
};


#endif