#include "machdefs.h"

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <complex>

#include "sophyainit.h"

#include "pexceptions.h"

#include "ppersist.h"
#include "fiondblock.h"
#include "dvlist.h"

#include "sversion.h"

// ---  Classe d'initialisation de SOPHYA, (PPersistMgr en particulier)
int SophyaInitiator::FgInit = 0;

SophyaInitiator::SophyaInitiator()
{
  FgInit++;
  if (FgInit > 1)  return;

  InitFailNewHandler();

  #ifdef xx__mac__
  //InitToolBox();
  //SIOUXSettings.initializeTB = FALSE;
  SIOUXSettings.autocloseonquit = FALSE;
  SIOUXSettings.asktosaveonclose = FALSE;
  SIOUXSettings.showstatusline = TRUE;
  #endif

  PIOPersist::Initialize();
  PPRegister(FIO_NDataBlock<uint_1>);
  DObjRegister(FIO_NDataBlock<uint_1>, NDataBlock<uint_1>);
  PPRegister(FIO_NDataBlock<uint_2>);
  DObjRegister(FIO_NDataBlock<uint_2>, NDataBlock<uint_2>);
  PPRegister(FIO_NDataBlock<int_2>);
  DObjRegister(FIO_NDataBlock<int_2>, NDataBlock<int_2>);
  PPRegister(FIO_NDataBlock<int_4>);
  DObjRegister(FIO_NDataBlock<int_4>, NDataBlock<int_4>);
  PPRegister(FIO_NDataBlock<int_8>);
  DObjRegister(FIO_NDataBlock<int_8>, NDataBlock<int_8>);
  PPRegister(FIO_NDataBlock<uint_4>);
  DObjRegister(FIO_NDataBlock<uint_4>, NDataBlock<uint_4>);
  PPRegister(FIO_NDataBlock<uint_8>);
  DObjRegister(FIO_NDataBlock<uint_8>, NDataBlock<uint_8>);
  PPRegister(FIO_NDataBlock<r_4>);
  DObjRegister(FIO_NDataBlock<r_4>, NDataBlock<r_4>);
  PPRegister(FIO_NDataBlock<r_8>);
  DObjRegister(FIO_NDataBlock<r_8>, NDataBlock<r_8>);
  PPRegister(FIO_NDataBlock< complex<r_4> >);
  DObjRegister(FIO_NDataBlock< complex<r_4> >, NDataBlock< complex<r_4> >);
  PPRegister(FIO_NDataBlock< complex<r_8> >);
  DObjRegister(FIO_NDataBlock< complex<r_8> >, NDataBlock< complex<r_8> >);

  PPRegister(ObjFileIO<DVList>);
  DObjRegister(ObjFileIO<DVList>, DVList);


#if (!defined(__GNUG__) && !defined(__MWERKS__) && !defined(HPUX))
  // pas de bufferisation pour printf   cmv 18/3/97 selon E.A.
  // setvbuf(stdout,NULL,_IOLBF,0); setvbuf(stderr,NULL,_IOLBF,0);
  setlinebuf(stdout);
  setlinebuf(stderr);
#endif

  // si var env SOPHYA_NOPRTVER definie pas de print
  if(!getenv("SOPHYA_NOPRTVER")) Version(true);

  int pnice;
  char* snice = getenv("SOPHYA_NICE");
  if (!snice) pnice=8;
  else pnice = atoi(snice);
  nice(pnice);

}

SophyaInitiator::~SophyaInitiator()
{
  FgInit--;
/*
  if (FgInit == 0)
    {
    delete PPersistMgr::classList; PPersistMgr::classList = NULL;
    delete PShPersist::objList;    PShPersist::objList = NULL;
    }
    */
}

double SophyaInitiator::Version(bool fgprt)
{
if (fgprt) {
  char* compiler = 0;
  #ifdef __GNUG__
  compiler = "gcc " __VERSION__;
  #endif
  #ifdef __DECCXX
  compiler = "cxx " ;
  #endif
  #ifdef __aCC__
  compiler = const_cast<char *>("HP-aCC ") ;
  #endif
  #ifdef __KCC__
  compiler = const_cast<char *>("KCC ") ;
  #endif
  #ifdef __SGICC__
  compiler = const_cast<char *>("SGI-CC ") ;
  #endif
  #ifdef __MWERKS__
  compiler = const_cast<char *>("Codewarrior ");
  #endif
  fprintf(stderr,"SOPHYA Version %4.1f Revision %d (%s) -- %s %s %s\n",
          SOPHYA_VERSION, SOPHYA_REVISION, SOPHYA_TAG,
          __DATE__, __TIME__, compiler);
}
return(SOPHYA_VERSION + (SOPHYA_REVISION/1000.));
}
 
// On met un objet initiator en statique, pour les loaders qui savent 
// appeler le constructeur des objets statiques   Reza 08/98
static SophyaInitiator psophyainit;
